# 🚀 Adım Adım Çözüm Rehberi

## 📋 Yapılacaklar Listesi

### 1️⃣ Sunucuda Apache Portunu Kontrol Et

SSH ile sunucuya bağlanın:

```bash
ssh kullanici@154.53.165.195
```

Apache'nin hangi portta çalıştığını kontrol edin:

```bash
# Apache durumunu kontrol et
sudo systemctl status apache2

# Apache portunu bul
sudo netstat -tlnp | grep apache
# veya
sudo ss -tlnp | grep apache
```

**Beklenen sonuç:** Genellikle `80` veya `8080` portunda çalışır.

### 2️⃣ Apache'nin Çalıştığından Emin Ol

```bash
# Apache çalışmıyorsa başlat
sudo systemctl start apache2

# Apache'nin otomatik başlamasını sağla
sudo systemctl enable apache2

# Durumunu kontrol et
sudo systemctl status apache2
```

**Beklenen sonuç:** `active (running)` görünmeli.

### 3️⃣ Apache Virtual Host Kontrolü

Apache'nin doğru klasörü serve ettiğinden emin olun:

```bash
# Apache config dosyasını kontrol et
sudo nano /etc/apache2/sites-available/000-default.conf
```

**Kontrol edilecekler:**
- `DocumentRoot` doğru klasörü gösteriyor mu? (örn: `/var/www/html` veya `/path/to/pwa-chatwoot`)
- `<Directory>` içinde `AllowOverride All` var mı?

**Örnek doğru config:**
```apache
<VirtualHost *:80>
    DocumentRoot /var/www/html
    # veya
    # DocumentRoot /path/to/pwa-chatwoot
    
    <Directory /var/www/html>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

Değişiklik yaptıysanız:
```bash
sudo systemctl restart apache2
```

### 4️⃣ Dosya Yapısını Kontrol Et

Proje klasöründe gerekli dosyalar var mı kontrol edin:

```bash
# Proje klasörüne git (kendi yolunuzu yazın)
cd /var/www/html
# veya
cd /path/to/pwa-chatwoot

# Gerekli dosyaları kontrol et
ls -la .htaccess
ls -la dist/
ls -la dist/index.html
ls -la public/inbox-settings.json
```

**Beklenen sonuç:**
- `.htaccess` dosyası var
- `dist/` klasörü var ve içinde `index.html` var
- `public/` klasörü var ve içinde JSON dosyaları var

### 5️⃣ Apache'yi Doğrudan Test Et

Sunucuda Apache'nin çalıştığını test edin:

```bash
# Localhost'tan test et
curl http://localhost/test232

# IP üzerinden test et
curl http://154.53.165.195/test232
```

**Beklenen sonuç:** HTML içeriği dönmeli (404 değil).

### 6️⃣ Nginx Proxy Manager Ayarlarını Düzelt

Nginx Proxy Manager web arayüzüne gidin ve mevcut proxy host'u düzenleyin:

#### 6.1. Details Sekmesi

- **Domain Names:** `domain.com` (kendi domain'iniz)
- **Scheme:** `http` (SSL yoksa) veya `https` (SSL varsa)
- **Forward Hostname/IP:** `154.53.165.195`
- **Forward Port:** `80` ⚠️ **ÖNEMLİ: 5173 değil, 80 olmalı!**
- **Cache Assets:** ✅ (İsteğe bağlı)
- **Block Common Exploits:** ✅
- **Websockets Support:** ✅

#### 6.2. SSL Sekmesi (Önerilen)

- **SSL Certificate:** Let's Encrypt ile otomatik SSL alın
- **Force SSL:** ✅
- **HTTP/2 Support:** ✅

#### 6.3. Kaydet

**Save** butonuna tıklayın.

### 7️⃣ Vite Dev Server'ı Kapat (Eğer Çalışıyorsa)

Vite dev server production için gerekli değil. Çalışıyorsa kapatın:

```bash
# Vite process'ini bul
ps aux | grep vite

# Process'i durdur (PID'yi yukarıdaki komuttan alın)
kill <PID>
# veya
pkill -f vite
```

### 8️⃣ Test Et

Tarayıcıda test edin:

1. **Ana sayfa:** `http://domain.com/` veya `https://domain.com/`
2. **Inbox test:** `http://domain.com/test232` veya `https://domain.com/test232`
3. **Admin panel:** `http://domain.com/admin/` veya `https://domain.com/admin/`
4. **JSON dosyası:** `http://domain.com/inbox-settings.json`

**Beklenen sonuç:** Sayfalar açılmalı, 502 veya 404 hatası olmamalı.

## 🐛 Sorun Giderme

### Sorun: "502 Bad Gateway"

**Çözüm:**
```bash
# 1. Apache çalışıyor mu?
sudo systemctl status apache2

# 2. Apache portunu kontrol et
sudo netstat -tlnp | grep apache

# 3. Nginx Proxy Manager'da port 80 mi? (5173 değil!)
```

### Sorun: "404 Not Found"

**Çözüm:**
```bash
# 1. .htaccess var mı?
ls -la .htaccess

# 2. dist/ klasörü var mı?
ls -la dist/

# 3. Apache mod_rewrite aktif mi?
sudo a2enmod rewrite
sudo systemctl restart apache2
```

### Sorun: "Internal Server Error"

**Çözüm:**
```bash
# Apache error log'u kontrol et
sudo tail -f /var/log/apache2/error.log
```

## ✅ Kontrol Listesi

- [ ] Apache çalışıyor (`sudo systemctl status apache2`)
- [ ] Apache portu bulundu (genellikle 80)
- [ ] Apache virtual host doğru klasörü gösteriyor
- [ ] `.htaccess` dosyası var
- [ ] `dist/` klasörü var ve içinde dosyalar var
- [ ] `public/` klasörü var
- [ ] Nginx Proxy Manager'da Forward Port = `80` (5173 değil!)
- [ ] Vite dev server kapatıldı
- [ ] Domain üzerinden test edildi

## 🎯 Özet

**En önemli adım:** Nginx Proxy Manager'da **Forward Port** değerini **5173'ten 80'e** değiştirin!

**Sıralama:**
1. Apache portunu bul (genellikle 80)
2. Apache'nin çalıştığından emin ol
3. Nginx Proxy Manager'da portu 80 yap
4. Test et

**Başarılar! 🎉**

