# 🚀 Admin Panel Hızlı Güncelleme

## 🔴 Sorun
Admin panelinde son güncellemeler (FCM, Kullanıcı Yönetimi, Firma Yönetimi) gözükmüyor.

## ✅ Çözüm

### Sadece 1 Dosya Yüklenecek:
- ✅ `admin/index.php` (2773 satır - güncel versiyon)

## 📋 Yükleme Adımları

### 1. Dosyayı Yükle

**WinSCP, FileZilla veya benzeri bir FTP/SFTP client kullanın:**

- **Lokal:** `C:\Users\Astro\Desktop\chat api\pwa-chatwoot\admin\index.php`
- **Sunucu:** `/var/www/html/admin/index.php`

### 2. Dosya İzinlerini Ayarla

```bash
chmod 644 admin/index.php
chmod 755 admin/
```

### 3. Browser Cache Temizle

- **Ctrl+Shift+Delete** - Cache'i temizle
- **Ctrl+F5** - Sayfayı yenile

### 4. Kontrol Et

Admin paneline giriş yapın: `https://api.blxchat.lol/admin`

**Yeni özellikler görünmeli:**
- ✅ FCM Ayarları bölümü
- ✅ Kullanıcı Yönetimi bölümü
- ✅ Firma Yönetimi bölümü
- ✅ Test Bildirimi butonu
- ✅ FCM Test butonu

## 🎯 Yeni Özellikler

### 1. FCM (Firebase Cloud Messaging)
- FCM Server Key ayarlama
- FCM Config ve VAPID Key ayarlama
- FCM Test butonu

### 2. Kullanıcı Yönetimi
- Yeni kullanıcı ekleme
- Kullanıcı düzenleme
- Kullanıcı silme
- Kullanıcıya inbox atama

### 3. Firma Yönetimi
- Yeni firma ekleme
- Firma düzenleme
- Firma silme
- Firma duyurusu ekleme

### 4. Test Bildirimi
- Test Bildirimi butonu
- FCM Test butonu

## 🔍 Kontrol

**Dosya yüklendi mi?**
```bash
# Sunucuda
ls -la /var/www/html/admin/index.php
wc -l /var/www/html/admin/index.php  # 2773 satır olmalı
```

**FCM özellikleri var mı?**
```bash
# Sunucuda
grep -i "FCM" /var/www/html/admin/index.php
```

## 🆘 Sorun Giderme

### "Hala eski özellikler görünüyor"

1. **Dosya yüklendi mi kontrol et:**
   ```bash
   ls -la /var/www/html/admin/index.php
   ```

2. **Browser cache'ini temizle:**
   - Ctrl+Shift+Delete
   - Cache'i temizle
   - Sayfayı yenile (Ctrl+F5)

3. **Incognito mode'da test et:**
   - Yeni bir incognito penceresi açın
   - Admin paneline giriş yapın

## ✅ Başarılı Güncelleme

Eğer her şey doğru yapıldıysa:
- ✅ FCM Ayarları bölümü görünüyor
- ✅ Kullanıcı Yönetimi bölümü görünüyor
- ✅ Firma Yönetimi bölümü görünüyor
- ✅ Test Bildirimi butonu görünüyor
- ✅ FCM Test butonu görünüyor

