# 🔄 Admin Panel Güncelleme Rehberi

## 🔴 Sorun

Admin panelinde son güncellemeler gözükmüyor. Bu, sunucudaki `admin/index.php` dosyasının eski olduğu anlamına gelir.

## ✅ Çözüm: Admin Panelini Güncelleme

### Yüklenecek Dosya

**Sadece 1 dosya yüklenecek:**
- ✅ `admin/index.php` (güncellenmiş versiyon)

## 📋 Yeni Özellikler (Eksik Olabilir)

### 1. FCM (Firebase Cloud Messaging) Ayarları
- ✅ FCM Server Key ayarlama (admin-config.json)
- ✅ FCM Config ve VAPID Key ayarlama (inbox bazında)
- ✅ FCM Test butonu (🔥 FCM Test)
- ✅ FCM bildirimi gönderme

### 2. Kullanıcı Yönetimi
- ✅ Yeni kullanıcı ekleme
- ✅ Kullanıcı düzenleme
- ✅ Kullanıcı silme
- ✅ Kullanıcıya inbox atama
- ✅ Kullanıcıya firma atama

### 3. Firma Yönetimi
- ✅ Yeni firma ekleme
- ✅ Firma düzenleme
- ✅ Firma silme
- ✅ Firma duyurusu ekleme
- ✅ Inbox'u firmaya atama

### 4. Test Bildirimi
- ✅ Test Bildirimi butonu (🔔 Test Bildirimi)
- ✅ FCM Test butonu (🔥 FCM Test)

### 5. Chatwoot Entegrasyonu
- ✅ Chatwoot inbox ayarlarını düzenleme
- ✅ Identifier bulma
- ✅ Webhook URL ayarlama

### 6. UI İyileştirmeleri
- ✅ Modern tasarım
- ✅ Responsive design
- ✅ Kullanıcı bilgisi kartı
- ✅ Badge'ler (Admin/Kullanıcı)

## 🚀 Güncelleme Adımları

### Adım 1: Yerel Dosyayı Kontrol Et

Yerel `admin/index.php` dosyasının güncel olduğundan emin olun:

```bash
# Dosya boyutunu kontrol et (güncel dosya ~2800 satır olmalı)
wc -l admin/index.php

# FCM özelliklerini kontrol et
grep -i "FCM" admin/index.php
```

**Beklenen sonuç:**
- Dosya ~2800 satır olmalı
- FCM ile ilgili kodlar bulunmalı
- Kullanıcı yönetimi kodları bulunmalı
- Firma yönetimi kodları bulunmalı

### Adım 2: Sunucuya Yükle

**WinSCP, FileZilla veya benzeri bir FTP/SFTP client kullanın:**

1. **Lokal dosya:**
   - `C:\Users\Astro\Desktop\chat api\pwa-chatwoot\admin\index.php`

2. **Sunucu hedefi:**
   - `/var/www/html/admin/index.php` (veya web root'unuz)

3. **Yükleme:**
   - Eski `admin/index.php` dosyasını yedekleyin (isteğe bağlı)
   - Yeni `admin/index.php` dosyasını yükleyin
   - Dosya izinlerini ayarlayın: `chmod 644 admin/index.php`

### Adım 3: Dosya İzinlerini Ayarla

SSH ile sunucuya bağlanın:

```bash
# PHP dosyası için
chmod 644 admin/index.php

# Klasör için
chmod 755 admin/
```

### Adım 4: Browser Cache Temizle

1. **Ctrl+Shift+Delete** - Cache'i temizle
2. **Ctrl+F5** - Sayfayı yenile (hard refresh)
3. **Veya:** Incognito/Private mode'da test et

### Adım 5: Kontrol Et

1. **Admin paneline giriş yapın:**
   - URL: `https://api.blxchat.lol/admin`
   - Kullanıcı Adı: `admin`
   - Şifre: `admin123`

2. **Yeni özellikleri kontrol edin:**
   - ✅ FCM Ayarları bölümü var mı?
   - ✅ Kullanıcı Yönetimi bölümü var mı?
   - ✅ Firma Yönetimi bölümü var mı?
   - ✅ Test Bildirimi butonu var mı?
   - ✅ FCM Test butonu var mı?

## 🔍 Kontrol Listesi

### Admin Panel Özellikleri

- [ ] **FCM Ayarları**
  - [ ] FCM Server Key ayarlama (admin-config.json)
  - [ ] FCM Config ve VAPID Key ayarlama (inbox bazında)
  - [ ] FCM Test butonu görünüyor mu?

- [ ] **Kullanıcı Yönetimi**
  - [ ] Kullanıcı Yönetimi bölümü var mı?
  - [ ] Yeni kullanıcı ekleme formu var mı?
  - [ ] Kullanıcı listesi görünüyor mu?

- [ ] **Firma Yönetimi**
  - [ ] Firma Yönetimi bölümü var mı?
  - [ ] Yeni firma ekleme formu var mı?
  - [ ] Firma listesi görünüyor mu?

- [ ] **Test Bildirimi**
  - [ ] Test Bildirimi butonu var mı?
  - [ ] FCM Test butonu var mı?

- [ ] **Chatwoot Entegrasyonu**
  - [ ] Chatwoot inbox ayarlarını düzenleme formu var mı?
  - [ ] Identifier bulma butonu var mı?
  - [ ] Webhook URL ayarlama alanı var mı?

- [ ] **UI İyileştirmeleri**
  - [ ] Modern tasarım görünüyor mu?
  - [ ] Kullanıcı bilgisi kartı var mı?
  - [ ] Badge'ler (Admin/Kullanıcı) görünüyor mu?

## 🚨 Sorun Giderme

### "Admin panelinde hala eski özellikler görünüyor"

1. **Dosya yüklendi mi?**
   ```bash
   # Sunucuda kontrol et
   ls -la /var/www/html/admin/index.php
   ```

2. **Dosya tarihini kontrol et:**
   ```bash
   # Sunucuda
   stat /var/www/html/admin/index.php
   ```
   - Dosya tarihi güncel olmalı (şimdi yüklenmiş olmalı)

3. **Browser cache'ini temizle:**
   - Ctrl+Shift+Delete
   - Cache'i temizle
   - Sayfayı yenile (Ctrl+F5)

4. **Incognito mode'da test et:**
   - Yeni bir incognito penceresi açın
   - Admin paneline giriş yapın
   - Yeni özellikler görünüyor mu?

### "FCM Ayarları bölümü görünmüyor"

1. **Dosyada FCM kodları var mı?**
   ```bash
   # Sunucuda kontrol et
   grep -i "FCM" /var/www/html/admin/index.php
   ```

2. **Eğer yoksa:**
   - Dosya yüklenmemiş olabilir
   - Dosyayı tekrar yükleyin
   - Dosya izinlerini kontrol edin

### "Kullanıcı Yönetimi bölümü görünmüyor"

1. **Admin olarak giriş yaptınız mı?**
   - Kullanıcı Yönetimi sadece admin için görünür
   - Kullanıcı Adı: `admin` olmalı

2. **Dosyada kullanıcı yönetimi kodları var mı?**
   ```bash
   # Sunucuda kontrol et
   grep -i "Kullanıcı Yönetimi" /var/www/html/admin/index.php
   ```

### "Test Bildirimi butonu görünmüyor"

1. **Inbox düzenleme formunda kontrol edin:**
   - Inbox'u düzenlemek için "✏️ Düzenle" butonuna tıklayın
   - Test URL'nin yanında "🔔 Test Bildirimi" butonu olmalı

2. **FCM Test butonu:**
   - FCM ayarları yapılmış inbox'larda görünür
   - "🔥 FCM Test" butonu görünmüyorsa, FCM ayarlarını kontrol edin

## 📝 Yeni Özellikler Detayları

### FCM Ayarları

**Admin Config (Global):**
- FCM Server Key: `admin-config.json` dosyasına kaydedilir
- Tüm inbox'lar için geçerlidir

**Inbox Bazında:**
- FCM Config: Firebase config JSON
- FCM VAPID Key: VAPID key
- FCM Enabled: Checkbox (aktif/pasif)

### Kullanıcı Yönetimi

**Özellikler:**
- Yeni kullanıcı ekleme
- Kullanıcı düzenleme
- Kullanıcı silme
- Kullanıcıya inbox atama
- Kullanıcıya firma atama

**Erişim:**
- Sadece admin kullanıcılar görebilir
- Normal kullanıcılar göremez

### Firma Yönetimi

**Özellikler:**
- Yeni firma ekleme
- Firma düzenleme
- Firma silme
- Firma duyurusu ekleme
- Inbox'u firmaya atama

**Erişim:**
- Sadece admin kullanıcılar görebilir
- Normal kullanıcılar göremez

### Test Bildirimi

**Özellikler:**
- Test Bildirimi butonu: Browser notification testi
- FCM Test butonu: FCM push notification testi

**Kullanım:**
- Test URL'nin yanında butonlar görünür
- Butona tıklayınca test bildirimi gönderilir

## ✅ Başarılı Güncelleme

Eğer her şey doğru yapıldıysa:

1. ✅ Admin paneline erişebiliyorsunuz
2. ✅ FCM Ayarları bölümü görünüyor
3. ✅ Kullanıcı Yönetimi bölümü görünüyor
4. ✅ Firma Yönetimi bölümü görünüyor
5. ✅ Test Bildirimi butonu görünüyor
6. ✅ FCM Test butonu görünüyor
7. ✅ Chatwoot entegrasyonu çalışıyor
8. ✅ UI modern ve responsive

## 📞 Destek

Sorun yaşarsanız:

1. **Dosya yüklendi mi kontrol edin:**
   ```bash
   ls -la /var/www/html/admin/index.php
   ```

2. **Dosya içeriğini kontrol edin:**
   ```bash
   grep -i "FCM" /var/www/html/admin/index.php
   grep -i "Kullanıcı Yönetimi" /var/www/html/admin/index.php
   ```

3. **Browser console'u kontrol edin:**
   - F12 > Console
   - Hata var mı kontrol edin

4. **Apache error log'unu kontrol edin:**
   ```bash
   sudo tail -f /var/log/apache2/error.log
   ```

## 🔗 İlgili Dosyalar

- `admin/index.php` - Admin paneli ana dosyası (GÜNCELLENMİŞ)
- `public/inbox-settings.json` - Inbox ayarları
- `public/users.json` - Kullanıcı bilgileri
- `public/companies.json` - Firma bilgileri
- `public/admin-config.json` - Admin yapılandırması (FCM Server Key)

## 📚 Ek Kaynaklar

- [Admin Panel Kullanım Rehberi](ADMIN-PANEL-KULLANIMI.md)
- [FCM Kurulum Rehberi](FCM-KURULUM.md)
- [Sunucu Güncelleme Rehberi](SUNUCU-GUNCELLEME.md)

