# 🔐 Admin Panel Kullanım Rehberi

## 📍 Admin Paneline Erişim

### Yerel (Localhost)
```
http://localhost/admin
```
veya
```
http://localhost/admin/index.php
```

### Sunucu (Production)
```
https://api.blxchat.lol/admin
```
veya
```
https://your-domain.com/admin
```

## 🔑 Giriş Bilgileri

### Admin (Tam Yetki)
- **Kullanıcı Adı:** `admin`
- **Şifre:** `admin123` (varsayılan)

### Normal Kullanıcı
- **Kullanıcı Adı:** `users.json` dosyasındaki kullanıcı adı (örn: `admin@example.com`)
- **Şifre:** `users.json` dosyasındaki şifre (örn: `password`)

## 🚀 Çalıştırma Adımları

### 1. Apache Web Sunucusu Çalışıyor Olmalı

**Linux Sunucu:**
```bash
# Apache durumunu kontrol et
sudo systemctl status apache2

# Apache başlat (eğer çalışmıyorsa)
sudo systemctl start apache2

# Apache'yi otomatik başlat (sunucu yeniden başladığında)
sudo systemctl enable apache2
```

**Windows (XAMPP/WAMP):**
- XAMPP/WAMP Control Panel'den Apache'yi başlatın

### 2. PHP Kurulu Olmalı

**Kontrol:**
```bash
php -v
```

**Gerekli PHP Extension'ları:**
- `curl` (Chatwoot API çağrıları için)
- `json` (JSON işlemleri için)
- `session` (Giriş yönetimi için)

### 3. Dosya İzinleri

**Linux Sunucu:**
```bash
# PHP dosyası için
chmod 644 admin/index.php

# JSON dosyaları için (yazılabilir olmalı)
chmod 666 public/inbox-settings.json
chmod 666 public/users.json
chmod 666 public/companies.json
chmod 666 public/admin-config.json

# Klasörler için
chmod 755 admin/
chmod 755 public/
```

### 4. Admin Paneline Erişim

1. **Tarayıcıyı açın**
2. **URL'yi girin:**
   - Yerel: `http://localhost/admin`
   - Sunucu: `https://api.blxchat.lol/admin`
3. **Giriş yapın:**
   - Kullanıcı Adı: `admin`
   - Şifre: `admin123`

## 📋 Admin Panel Özellikleri

### 1. Inbox Yönetimi
- ✅ Yeni inbox ekleme
- ✅ Mevcut inbox'ları düzenleme
- ✅ Inbox silme
- ✅ Logo yükleme
- ✅ Tema renkleri ayarlama
- ✅ Duyuru metni ve linki ekleme

### 2. Chatwoot Entegrasyonu
- ✅ Chatwoot API ayarları
- ✅ Inbox identifier bulma
- ✅ Chatwoot inbox ayarlarını düzenleme
- ✅ Webhook URL ayarlama

### 3. FCM (Firebase Cloud Messaging)
- ✅ FCM Server Key ayarlama
- ✅ FCM Config ve VAPID Key ayarlama
- ✅ FCM test bildirimi gönderme

### 4. Kullanıcı Yönetimi
- ✅ Yeni kullanıcı ekleme
- ✅ Kullanıcı düzenleme
- ✅ Kullanıcı silme
- ✅ Kullanıcıya inbox atama
- ✅ Kullanıcıya firma atama

### 5. Firma Yönetimi
- ✅ Yeni firma ekleme
- ✅ Firma düzenleme
- ✅ Firma silme
- ✅ Firma duyurusu ekleme
- ✅ Inbox'u firmaya atama

## 🔧 Yapılandırma

### Admin Şifresini Değiştirme

`admin/index.php` dosyasını düzenleyin:

```php
// Satır 16
$ADMIN_PASSWORD = 'yeni-sifreniz'; // Bu şifreyi değiştirin!
```

### Chatwoot API Ayarları

1. Admin paneline giriş yapın
2. "⚙️ BLXChat API Ayarları" bölümüne gidin
3. Aşağıdaki bilgileri girin:
   - **API URL:** `http://app.blxchat.lol` (veya HTTPS)
   - **API Token:** Chatwoot API token'ınız
   - **Account ID:** Chatwoot account ID'niz
4. "Kaydet" butonuna tıklayın

### FCM Ayarları

1. Admin paneline giriş yapın
2. "⚙️ BLXChat API Ayarları" bölümüne gidin
3. "FCM Server Key" alanına Firebase Server Key'inizi girin
4. "Kaydet" butonuna tıklayın

## 🚨 Sorun Giderme

### "Admin paneline erişemiyorum"

1. **Apache çalışıyor mu?**
   ```bash
   sudo systemctl status apache2
   ```

2. **PHP çalışıyor mu?**
   ```bash
   php -v
   ```

3. **Dosya yolu doğru mu?**
   - `admin/index.php` dosyası var mı?
   - Web root'ta mı? (`/var/www/html/admin/`)

4. **.htaccess dosyası doğru mu?**
   - `.htaccess` dosyası admin klasörüne erişimi engelliyor mu?

### "Giriş yapamıyorum"

1. **Şifre doğru mu?**
   - Varsayılan şifre: `admin123`
   - `admin/index.php` dosyasındaki şifreyi kontrol edin

2. **Session çalışıyor mu?**
   - PHP session extension'ı yüklü mü?
   - Session dosyaları yazılabilir mi?

3. **Kullanıcı adı doğru mu?**
   - Admin için: `admin`
   - Normal kullanıcı için: `users.json` dosyasındaki kullanıcı adı

### "Inbox kaydedemiyorum"

1. **JSON dosyası yazılabilir mi?**
   ```bash
   chmod 666 public/inbox-settings.json
   ```

2. **Dosya yolu doğru mu?**
   - `public/inbox-settings.json` dosyası var mı?
   - Dosya yolu doğru mu?

3. **PHP hatalarını kontrol edin:**
   - Browser console'u kontrol edin
   - Apache error log'unu kontrol edin: `sudo tail -f /var/log/apache2/error.log`

### "Chatwoot API çağrıları çalışmıyor"

1. **API ayarları doğru mu?**
   - API URL doğru mu?
   - API Token doğru mu?
   - Account ID doğru mu?

2. **cURL extension yüklü mü?**
   ```bash
   php -m | grep curl
   ```

3. **SSL sertifikası doğru mu?**
   - HTTPS kullanıyorsanız, SSL sertifikası geçerli mi?
   - `curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);` satırını kontrol edin

## 📝 Kullanım Örnekleri

### Yeni Inbox Ekleme

1. Admin paneline giriş yapın
2. "➕ Yeni Inbox Ekle" butonuna tıklayın
3. Aşağıdaki bilgileri girin:
   - **Inbox ID:** `test-inbox-1`
   - **App Name:** `Test Inbox 1`
   - **Logo URL:** `https://example.com/logo.png`
   - **Chatwoot API Base URL:** `https://app.blxchat.lol`
   - **Chatwoot Inbox ID:** Chatwoot'tan aldığınız inbox ID
4. "Inbox Ekle" butonuna tıklayın

### Inbox Düzenleme

1. Admin paneline giriş yapın
2. Düzenlemek istediğiniz inbox'u bulun
3. "✏️ Düzenle" butonuna tıklayın
4. İstediğiniz alanları düzenleyin
5. "💾 Kaydet" butonuna tıklayın

### Kullanıcı Ekleme

1. Admin paneline giriş yapın (admin olarak)
2. "👥 Kullanıcı Yönetimi" bölümüne gidin
3. "➕ Yeni Kullanıcı Ekle" butonuna tıklayın
4. Aşağıdaki bilgileri girin:
   - **Kullanıcı Adı:** `user@example.com`
   - **Şifre:** `password123`
   - **Ad:** `Ahmet`
   - **Email:** `user@example.com`
   - **Atanan Inbox'lar:** `test232`, `testbaba1`
   - **Firma:** `company_6910beed2bcde`
5. "Kullanıcı Ekle" butonuna tıklayın

### Firma Ekleme

1. Admin paneline giriş yapın (admin olarak)
2. "🏢 Firma Yönetimi" bölümüne gidin
3. "➕ Yeni Firma Ekle" butonuna tıklayın
4. Aşağıdaki bilgileri girin:
   - **Firma Adı:** `Betlab`
   - **Açıklama:** `Betlab Firma Açıklaması`
   - **Duyuru Metni:** `Güncel linkimiz tıkla`
   - **Duyuru Linki:** `https://google.com`
5. "Firma Ekle" butonuna tıklayın

## 🔒 Güvenlik Önerileri

### 1. Şifre Değiştirme
- ✅ Varsayılan şifreyi değiştirin (`admin123`)
- ✅ Güçlü bir şifre kullanın
- ✅ Şifreyi düzenli olarak değiştirin

### 2. HTTPS Kullanımı
- ✅ Production'da mutlaka HTTPS kullanın
- ✅ SSL sertifikası kullanın (Let's Encrypt ücretsiz)

### 3. Dosya İzinleri
- ✅ JSON dosyaları sadece yazılabilir olmalı (`chmod 666`)
- ✅ PHP dosyaları sadece okunabilir olmalı (`chmod 644`)
- ✅ Klasörler yürütülebilir olmalı (`chmod 755`)

### 4. Güvenlik Duvarı
- ✅ Admin paneline sadece belirli IP'lerden erişime izin verin
- ✅ Fail2ban kullanın (brute force saldırılarına karşı)

### 5. Yedekleme
- ✅ JSON dosyalarını düzenli olarak yedekleyin
- ✅ Otomatik yedekleme sistemi kurun

## 📞 Destek

Sorun yaşarsanız:
1. Browser console'u kontrol edin (F12)
2. Apache error log'unu kontrol edin
3. PHP error log'unu kontrol edin
4. Dosya izinlerini kontrol edin
5. Network sekmesini kontrol edin (API çağrıları)

## ✅ Başarılı Kurulum Kontrolü

Admin paneli başarıyla çalışıyorsa:
1. ✅ Admin paneline erişebiliyorsunuz
2. ✅ Giriş yapabiliyorsunuz
3. ✅ Inbox ekleyebiliyorsunuz
4. ✅ Inbox düzenleyebiliyorsunuz
5. ✅ Inbox silebiliyorsunuz
6. ✅ Kullanıcı ekleyebiliyorsunuz
7. ✅ Firma ekleyebiliyorsunuz
8. ✅ Chatwoot API çağrıları çalışıyor
9. ✅ FCM ayarları kaydediliyor

## 🔗 İlgili Dosyalar

- `admin/index.php` - Admin paneli ana dosyası
- `public/inbox-settings.json` - Inbox ayarları
- `public/users.json` - Kullanıcı bilgileri
- `public/companies.json` - Firma bilgileri
- `public/admin-config.json` - Admin yapılandırması
- `.htaccess` - Apache yapılandırması

## 📚 Ek Kaynaklar

- [Apache Kurulum Rehberi](SETUP-SCRIPT-KULLANIMI.md)
- [Sunucu Güncelleme Rehberi](SUNUCU-GUNCELLEME.md)
- [FCM Kurulum Rehberi](FCM-KURULUM.md)
- [Mixed Content Çözüm Rehberi](MIXED-CONTENT-COZUM.md)

