# 🔔 Admin Panel - Test Bildirimi Özelliği

## ✅ Yeni Özellik

Admin panelinde her inbox için **"🔔 Test Bildirimi"** butonu eklendi.

## 🚀 Kullanım

### 1. Admin Panelinde Test Bildirimi Gönderme

1. Admin paneline giriş yapın: `http://domain.com/admin/`
2. İnbox listesinde istediğiniz inbox'u bulun
3. **"🔔 Test Bildirimi"** butonuna tıklayın
4. Test URL'si yeni sekmede açılacak (`?test_notification=1` parametresi ile)
5. Sayfa yüklendikten sonra:
   - Bildirim izni verilmemişse: İzin istenir
   - Bildirim izni verilmişse: Test bildirimi otomatik olarak gönderilir

### 2. Manuel Test

Test URL'sine manuel olarak `?test_notification=1` parametresi ekleyebilirsiniz:

```
https://api.blxchat.lol/test1234?test_notification=1
```

## 📋 Özellikler

- ✅ **Dinamik URL:** Admin panelinin açıldığı domain'den otomatik URL oluşturulur
- ✅ **Otomatik İzin:** İzin verilmemişse otomatik olarak istenir
- ✅ **Test Bildirimi:** İzin verildikten sonra otomatik test bildirimi gönderilir
- ✅ **Platform Desteği:** Android ve iOS için optimize edilmiş

## 🔍 Nasıl Çalışıyor?

1. **Admin Panelinde Buton:**
   - Her inbox için "🔔 Test Bildirimi" butonu görünür
   - Butona tıklandığında test URL'si yeni sekmede açılır
   - URL'ye `?test_notification=1` parametresi eklenir

2. **Test URL'si Açıldığında:**
   - Sayfa yüklenir
   - URL parametresi kontrol edilir
   - Bildirim izni kontrol edilir
   - İzin verilmişse test bildirimi gönderilir
   - İzin verilmemişse izin istenir, sonra test bildirimi gönderilir

## 🧪 Test Adımları

### 1. Admin Panelinden Test

```bash
# Admin paneline giriş yap
http://domain.com/admin/

# İnbox listesinde "🔔 Test Bildirimi" butonuna tıkla
# Yeni sekme açılacak ve test bildirimi gönderilecek
```

### 2. Manuel Test

```bash
# Test URL'sine ?test_notification=1 parametresi ekle
https://api.blxchat.lol/test1234?test_notification=1
```

## 📱 Mobil Test

### Android

1. Admin panelinden "🔔 Test Bildirimi" butonuna tıklayın
2. Mobil cihazda sayfa açılacak
3. Bildirim izni verin
4. Test bildirimi gönderilecek

### iOS

1. Admin panelinden "🔔 Test Bildirimi" butonuna tıklayın
2. Mobil cihazda sayfa açılacak
3. **ÖNEMLİ:** iOS'ta bildirimler için PWA modu gereklidir
4. Ana ekrana ekleyin ve PWA modunda açın
5. Bildirim izni verin
6. Test bildirimi gönderilecek

## 🐛 Sorun Giderme

### Sorun: "Test bildirimi gönderilmedi"

**Çözüm:**
1. Bildirim izninin verildiğini kontrol edin
2. Console'da hata var mı kontrol edin (F12 → Console)
3. Service Worker'ın kayıtlı olduğunu kontrol edin
4. HTTPS bağlantısı kullanıldığından emin olun

### Sorun: "Pop-up engellendi"

**Çözüm:**
1. Tarayıcı pop-up ayarlarından izin verin
2. Test URL'sine manuel olarak gidin
3. URL'ye `?test_notification=1` parametresi ekleyin

### Sorun: "iOS'ta bildirim gelmiyor"

**Çözüm:**
1. Uygulamanın PWA modunda açıldığından emin olun
2. Ana ekrandan uygulamayı açın (Safari'den değil)
3. Bildirim izninin verildiğini kontrol edin
4. iOS 16.4+ kullandığınızdan emin olun

## 📝 Özet

- ✅ Admin panelinde test bildirimi butonu eklendi
- ✅ Dinamik URL oluşturma
- ✅ Otomatik bildirim izni isteme
- ✅ Test bildirimi otomatik gönderme
- ✅ Android ve iOS desteği

**Başarılar! 🎉**

