# 🔧 Beyaz Ekran Sorunu Çözümü

## ❌ Sorun

Domain üzerinden erişildiğinde sayfa beyaz ekranda kalıyor.

## 🔍 Neden Oluyor?

Build edilmiş JavaScript dosyaları `/assets/main-xxx.js` path'inden yükleniyor ama bu dosyalar `dist/assets/` klasöründe. `.htaccess` bu path'i yönlendirmiyordu.

## ✅ Çözüm

`.htaccess` dosyasına `/assets/` path'ini `/dist/assets/` olarak yönlendiren kural eklendi.

## 📤 Sunucuya Yükleme

### 1. Güncellenmiş `.htaccess` Dosyasını Yükle

Lokal: `C:\Users\Astro\Desktop\chat api\pwa-chatwoot\.htaccess`
Sunucu: `/path/to/pwa-chatwoot/.htaccess`

### 2. Apache'yi Restart Et

SSH ile sunucuya bağlanın:

```bash
ssh kullanici@154.53.165.195
sudo systemctl restart apache2
```

### 3. Test Et

Tarayıcıda:
- `http://domain.com/test232`
- F12 → Console → Hata var mı kontrol et
- Network sekmesi → JavaScript dosyaları yükleniyor mu kontrol et

## 🐛 Hala Beyaz Ekran Varsa

### 1. Tarayıcı Console'unu Kontrol Et

F12 → Console → Hata mesajlarını kontrol et

**Yaygın hatalar:**
- `Failed to load resource: net::ERR_ABORTED 404` → JavaScript dosyası bulunamıyor
- `Uncaught SyntaxError` → JavaScript dosyası bozuk
- `Uncaught ReferenceError` → Modül yüklenmemiş

### 2. Network Sekmesini Kontrol Et

F12 → Network → Sayfayı yenile (F5)

**Kontrol edilecekler:**
- `index.html` → 200 OK
- `assets/main-xxx.js` → 200 OK (404 değil!)
- `assets/main-xxx.css` → 200 OK (varsa)

### 3. Apache Error Log'unu Kontrol Et

```bash
sudo tail -f /var/log/apache2/error.log
```

### 4. Dosya Yapısını Kontrol Et

```bash
# dist/ klasörü var mı?
ls -la /path/to/pwa-chatwoot/dist/

# assets/ klasörü var mı?
ls -la /path/to/pwa-chatwoot/dist/assets/

# JavaScript dosyası var mı?
ls -la /path/to/pwa-chatwoot/dist/assets/*.js
```

### 5. Build Kontrolü

Eğer `dist/` klasörü yoksa veya eskiyse:

```bash
# Lokalde build yap
npm run build

# dist/ klasörünü sunucuya yükle
```

## ✅ Kontrol Listesi

- [ ] `.htaccess` dosyası güncel (assets/ yönlendirmesi var)
- [ ] `dist/` klasörü mevcut
- [ ] `dist/assets/` klasörü mevcut
- [ ] `dist/assets/*.js` dosyaları var
- [ ] Apache restart edildi
- [ ] Tarayıcı cache temizlendi (Ctrl+Shift+R)
- [ ] Console'da hata yok
- [ ] Network'te JavaScript dosyaları 200 OK

## 🚀 Hızlı Test

```bash
# Sunucuda test
curl http://localhost/assets/main-KhkUB82y.js

# Eğer 404 veriyorsa, path yanlış
# Eğer 200 OK veriyorsa, path doğru
```

## 📝 Özet

1. **Güncellenmiş `.htaccess` dosyasını sunucuya yükle**
2. **Apache'yi restart et:** `sudo systemctl restart apache2`
3. **Tarayıcı cache'ini temizle:** Ctrl+Shift+R
4. **Test et:** `http://domain.com/test232`

**Başarılar! 🎉**

