# 🔔 Bildirim Hızlı Kontrol Listesi

## ⚡ Hızlı Kontrol (5 Dakika)

### 1. Browser Console Kontrolü

F12 > Console'u açın ve şu logları kontrol edin:

**✅ Başarılı:**
```
🔥 FCM: Initialize ediliyor...
✅ FCM: Firebase config ayarlandı
✅ FCM: Messaging initialize edildi
✅ FCM: Token alındı
✅ FCM: Token backend'e gönderildi
✅ Service Worker kayıtlı
```

**❌ Hata Varsa:**
- `❌ FCM: Config ayarlanamadı` → Admin panelinde FCM Config eksik
- `❌ FCM: Token alınamadı` → VAPID Key eksik veya yanlış
- `⚠️ FCM: Bildirim izni verilmemiş` → İzin verilmemiş

### 2. Notification İzni

Console'da çalıştırın:
```javascript
Notification.permission
```

**Beklenen:** `"granted"`

**Değilse:**
- Tarayıcı ayarlarından bildirim iznini açın
- Sayfayı yenileyin ve izin isteğini kabul edin

### 3. Admin Panel Kontrolü

1. **FCM Server Key:**
   - Admin Panel > ⚙️ BLXChat API Ayarları
   - "FCM Server Key" dolu mu?

2. **Inbox FCM Ayarları:**
   - Inbox Düzenle
   - 🔔 FCM Ayarları bölümü
   - ✅ FCM Enabled işaretli mi?
   - ✅ Firebase Config dolu mu?
   - ✅ VAPID Key dolu mu?

### 4. Test Bildirimi

**Yöntem 1: Admin Panel**
- Admin Panel > Inbox Listesi
- "🔔 Test Bildirimi" butonuna tıklayın

**Yöntem 2: URL Parametresi**
- `https://api.blxchat.lol/test232?test_notification=1`

**Yöntem 3: FCM Test**
- Admin Panel > "🔥 FCM Test" butonuna tıklayın

## 🚨 Yaygın Sorunlar

### ❌ "FCM Config ayarlanamadı"
**Çözüm:** Admin panelinde FCM Config JSON'u kontrol edin

### ❌ "Token alınamadı"
**Çözüm:** VAPID Key'i kontrol edin (Firebase Console)

### ❌ "Bildirim izni verilmemiş"
**Çözüm:** Tarayıcı ayarlarından bildirim iznini açın

### ❌ "iOS'ta çalışmıyor"
**Çözüm:** Uygulamayı ana ekrana ekleyin (PWA modu gerekli)

### ❌ "Yeni mesajlarda bildirim gelmiyor"
**Çözüm:** 
- PC'de sayfa gizli olmalı
- Mobilde sayfa açık olsa bile bildirim gelir
- Console'da `🔔 Yeni agent mesajı tespit edildi` logunu kontrol edin

## 📋 Detaylı Rehber

Detaylı sorun giderme için: [BILDIRIM-SORUN-GIDERME.md](BILDIRIM-SORUN-GIDERME.md)

