# 🔔 Bildirim Sorun Giderme Rehberi

## 🔴 Bildirim Problemi

Bildirimler çalışmıyor veya gelmiyor. Bu rehber ile sorunu tespit edip çözebilirsiniz.

## 🔍 Sorun Tespiti

### 1. Browser Console Kontrolü

F12 > Console'u açın ve şu logları kontrol edin:

**FCM Initialize:**
- ✅ `🔥 FCM: Initialize ediliyor...`
- ✅ `✅ FCM: Firebase config ayarlandı`
- ✅ `✅ FCM: Messaging initialize edildi`
- ✅ `✅ FCM: Token alındı`
- ✅ `✅ FCM: Token backend'e gönderildi`

**Eğer hata görüyorsanız:**
- ❌ `❌ FCM: Config ayarlanamadı` → FCM Config eksik
- ❌ `❌ FCM: Messaging initialize edilemedi` → Firebase SDK sorunu
- ❌ `❌ FCM: Token alınamadı` → VAPID Key eksik veya yanlış
- ❌ `⚠️ FCM: Bildirim izni verilmemiş` → İzin verilmemiş

**Service Worker:**
- ✅ `✅ Service Worker kayıtlı`
- ✅ `✅ Service Worker aktif`

**Bildirim Gönderme:**
- ✅ `🔔 Bildirim gönderiliyor: ...`
- ✅ `📱 Platform: Android/iOS/PC`

### 2. Notification İzni Kontrolü

Browser Console'da şunu çalıştırın:
```javascript
Notification.permission
```

**Beklenen sonuç:**
- ✅ `"granted"` → İzin verilmiş
- ⚠️ `"default"` → İzin istenmemiş
- ❌ `"denied"` → İzin reddedilmiş

**İzin verilmemişse:**
1. Tarayıcı ayarlarından bildirim iznini açın
2. Veya sayfayı yenileyin ve izin isteğini kabul edin

### 3. FCM Ayarları Kontrolü

**Admin Panelinde:**
1. Admin paneline giriş yapın: `https://api.blxchat.lol/admin`
2. Inbox'u düzenleyin
3. "🔔 FCM (Firebase Cloud Messaging) Ayarları" bölümünü kontrol edin:
   - ✅ FCM Enabled checkbox işaretli mi?
   - ✅ Firebase Config (JSON) dolu mu?
   - ✅ VAPID Key dolu mu?

**Admin Config:**
1. "⚙️ BLXChat API Ayarları" bölümüne gidin
2. "FCM Server Key" alanını kontrol edin:
   - ✅ FCM Server Key dolu mu?

### 4. Service Worker Kontrolü

Browser Console'da şunu çalıştırın:
```javascript
navigator.serviceWorker.getRegistrations().then(regs => console.log(regs))
```

**Beklenen:**
- Service Worker kayıtlı olmalı
- `firebase-messaging-sw.js` veya `service-worker.js` görünmeli

**Service Worker yoksa:**
1. Sayfayı yenileyin (Ctrl+F5)
2. Browser cache'ini temizleyin
3. Service Worker dosyalarının sunucuda olduğundan emin olun:
   - `public/firebase-messaging-sw.js`
   - `public/service-worker.js`

### 5. FCM Token Kontrolü

**Backend'de:**
```bash
# Sunucuda
cat public/fcm-tokens.json
```

**Beklenen:**
- Inbox ID için token'lar olmalı
- Token'lar güncel olmalı

**Token yoksa:**
1. Sayfayı yenileyin
2. Browser Console'da FCM token alınıyor mu kontrol edin
3. `/api/fcm-token.php` endpoint'i çalışıyor mu kontrol edin

## 🚨 Yaygın Sorunlar ve Çözümleri

### Sorun 1: "FCM Config ayarlanamadı"

**Neden:**
- FCM Config JSON eksik veya yanlış
- Firebase Config formatı hatalı

**Çözüm:**
1. Admin panelinde FCM Config'i kontrol edin
2. Firebase Console'dan doğru config'i kopyalayın
3. JSON formatının doğru olduğundan emin olun:
   ```json
   {
     "apiKey": "...",
     "authDomain": "...",
     "projectId": "...",
     "storageBucket": "...",
     "messagingSenderId": "...",
     "appId": "..."
   }
   ```

### Sorun 2: "Token alınamadı"

**Neden:**
- VAPID Key eksik veya yanlış
- Notification izni verilmemiş
- Firebase Messaging initialize edilememiş

**Çözüm:**
1. VAPID Key'i kontrol edin (Firebase Console > Cloud Messaging > Web Push certificates)
2. Notification iznini verin
3. Browser Console'da hata var mı kontrol edin

### Sorun 3: "Bildirim izni verilmemiş"

**Neden:**
- Kullanıcı izni reddetmiş
- Tarayıcı ayarlarından izin kapatılmış

**Çözüm:**
1. Tarayıcı ayarlarından bildirim iznini açın:
   - Chrome: `chrome://settings/content/notifications`
   - Firefox: `about:preferences#privacy`
   - Safari: Sistem Tercihleri > Bildirimler
2. Sayfayı yenileyin ve izin isteğini kabul edin

### Sorun 4: "iOS'ta bildirimler çalışmıyor"

**Neden:**
- iOS'ta bildirimler sadece PWA modunda çalışır
- Uygulama ana ekrana eklenmemiş

**Çözüm:**
1. Safari'de paylaş butonuna basın
2. "Ana Ekrana Ekle" seçeneğini seçin
3. Uygulamayı ana ekrandan açın
4. Bildirim iznini verin

### Sorun 5: "Android'de bildirimler çalışmıyor"

**Neden:**
- FCM Server Key eksik
- FCM token alınamıyor
- Service Worker çalışmıyor

**Çözüm:**
1. FCM Server Key'i admin panelinde ayarlayın
2. FCM Config ve VAPID Key'i inbox'e ekleyin
3. Sayfayı yenileyin ve token'ın alındığını kontrol edin
4. Service Worker'ın çalıştığını kontrol edin

### Sorun 6: "Yeni mesajlarda bildirim gelmiyor"

**Neden:**
- Polling sistemi çalışmıyor
- Yeni mesaj tespit edilemiyor
- Bildirim gönderme mantığı çalışmıyor

**Çözüm:**
1. Browser Console'da polling loglarını kontrol edin:
   - `🔔 Yeni agent mesajı tespit edildi`
   - `🔔 Bildirim gönderiliyor`
2. Sayfa gizli mi kontrol edin (PC'de sadece sayfa gizliyken bildirim gönderilir)
3. Mobil cihazlarda sayfa açık olsa bile bildirim gönderilir

### Sorun 7: "FCM Test butonu çalışmıyor"

**Neden:**
- FCM Server Key eksik
- FCM token'ları yok
- Backend endpoint çalışmıyor

**Çözüm:**
1. Admin panelinde FCM Server Key'i kontrol edin
2. `public/fcm-tokens.json` dosyasında token'lar var mı kontrol edin
3. `/api/fcm-send.php` endpoint'i çalışıyor mu kontrol edin:
   ```bash
   # Sunucuda
   curl -X POST https://api.blxchat.lol/api/fcm-send.php \
     -H "Content-Type: application/json" \
     -d '{"inboxId":"test232","title":"Test","body":"Test mesajı"}'
   ```

## 🔧 Adım Adım Çözüm

### Adım 1: FCM Ayarlarını Kontrol Et

1. **Admin Paneline Giriş:**
   - URL: `https://api.blxchat.lol/admin`
   - Kullanıcı Adı: `admin`
   - Şifre: `admin123`

2. **FCM Server Key Ayarla:**
   - "⚙️ BLXChat API Ayarları" bölümüne gidin
   - "FCM Server Key" alanına Firebase Server Key'i girin
   - "Kaydet" butonuna tıklayın

3. **Inbox FCM Ayarları:**
   - Inbox'u düzenleyin
   - "🔔 FCM (Firebase Cloud Messaging) Ayarları" bölümünü açın
   - "FCM Bildirimleri Etkinleştir" checkbox'ını işaretleyin
   - Firebase Config (JSON) girin
   - VAPID Key girin
   - "💾 Kaydet" butonuna tıklayın

### Adım 2: Build ve Yükleme

1. **Build Et:**
   ```bash
   cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"
   npm run build
   ```

2. **Sunucuya Yükle:**
   - `dist/` klasörü
   - `public/` klasörü (firebase-messaging-sw.js dahil)
   - `admin/` klasörü

### Adım 3: Test Et

1. **Sayfayı Aç:**
   - `https://api.blxchat.lol/test232`

2. **Browser Console'u Aç:**
   - F12 > Console

3. **FCM Initialize Loglarını Kontrol Et:**
   - `🔥 FCM: Initialize ediliyor...`
   - `✅ FCM: Token alındı`
   - `✅ FCM: Token backend'e gönderildi`

4. **Test Bildirimi Gönder:**
   - Admin panelinde "🔔 Test Bildirimi" butonuna tıklayın
   - Veya URL'ye `?test_notification=1` ekleyin

5. **FCM Test Bildirimi Gönder:**
   - Admin panelinde "🔥 FCM Test" butonuna tıklayın

## 📋 Kontrol Listesi

### FCM Ayarları
- [ ] FCM Server Key admin-config.json'da var
- [ ] FCM Config inbox-settings.json'da var
- [ ] VAPID Key inbox-settings.json'da var
- [ ] FCM Enabled checkbox işaretli

### Service Worker
- [ ] Service Worker kayıtlı
- [ ] firebase-messaging-sw.js yüklendi
- [ ] Service Worker aktif

### Notification İzni
- [ ] Notification.permission === "granted"
- [ ] Tarayıcı ayarlarında izin açık

### FCM Token
- [ ] FCM token alındı
- [ ] Token backend'e gönderildi
- [ ] fcm-tokens.json dosyasında token var

### Test
- [ ] Test bildirimi çalışıyor
- [ ] FCM test bildirimi çalışıyor
- [ ] Yeni mesajlarda bildirim geliyor

## 🆘 Hala Çalışmıyorsa

1. **Browser Console Loglarını Paylaşın:**
   - F12 > Console
   - Tüm logları kopyalayın

2. **Network Sekmesini Kontrol Edin:**
   - F12 > Network
   - `/api/fcm-token.php` çağrısı var mı?
   - `/api/fcm-send.php` çağrısı var mı?
   - Hata kodları neler?

3. **Sunucu Loglarını Kontrol Edin:**
   ```bash
   # Apache error log
   sudo tail -f /var/log/apache2/error.log
   ```

4. **FCM Token Dosyasını Kontrol Edin:**
   ```bash
   # Sunucuda
   cat public/fcm-tokens.json
   ```

## ✅ Başarılı Kurulum

Eğer her şey doğru yapıldıysa:

1. ✅ FCM initialize edildi
2. ✅ FCM token alındı
3. ✅ Token backend'e gönderildi
4. ✅ Service Worker kayıtlı
5. ✅ Notification izni verildi
6. ✅ Test bildirimi çalışıyor
7. ✅ FCM test bildirimi çalışıyor
8. ✅ Yeni mesajlarda bildirim geliyor

## 🔗 İlgili Dosyalar

- `src/App.jsx` - Bildirim gönderme mantığı
- `src/services/fcm.js` - FCM servisi
- `public/firebase-messaging-sw.js` - FCM Service Worker
- `public/api/fcm-token.php` - FCM token kaydetme
- `public/api/fcm-send.php` - FCM bildirim gönderme
- `public/admin-config.json` - FCM Server Key
- `public/inbox-settings.json` - FCM Config ve VAPID Key

## 📚 Ek Kaynaklar

- [FCM Kurulum Rehberi](FCM-KURULUM.md)
- [FCM Test Adımları](FCM-TEST-ADIMLARI.md)
- [Mobil Bildirim Rehberi](MOBIL-BILDIRIM-REHBERI.md)
- [Admin Panel Kullanımı](ADMIN-PANEL-KULLANIMI.md)

