# 🚨 call.betlabx.com Sorunu - Acil Çözüm

## 🔴 Sorun

Uygulama hala `call.betlabx.com` API'si ile haberleşiyor.

## ✅ Hızlı Çözüm (3 Adım)

### Adım 1: Sunucudaki JSON Dosyasını Kontrol Et

**SSH ile sunucuya bağlanın:**
```bash
cat /var/www/html/public/inbox-settings.json | grep chatwootBaseUrl
```

**Eğer `call.betlabx.com` görüyorsanız:**

**Seçenek A: Admin Panelinden Güncelle**
1. Admin paneline giriş: `https://api.blxchat.lol/admin`
2. `test232` inbox'unu düzenle
3. "Chatwoot Base URL (Domain)" alanını `https://app.blxchat.lol` olarak güncelle
4. "💾 Kaydet" butonuna tıklayın

**Seçenek B: Manuel Düzenle**
```bash
# Sunucuda
nano /var/www/html/public/inbox-settings.json
# chatwootBaseUrl değerini "https://app.blxchat.lol" olarak değiştirin
```

### Adım 2: Build ve Yükleme

**Yerel:**
```bash
cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"
npm run build
```

**Sunucuya Yükle:**
- `dist/` klasörü (yeni build)
- `public/inbox-settings.json` (güncellenmiş)

### Adım 3: Browser Cache Temizle

1. **Ctrl+Shift+Delete** - Cache'i temizle
2. **Ctrl+F5** - Sayfayı yenile
3. **Veya:** Incognito mode'da test et

## 🔍 Kontrol

### Browser Console

F12 > Console'u açın:

**Başarılı:**
```
🔧 Chatwoot Base URL güncelleniyor: https://app.blxchat.lol
🌐 Chatwoot Base URL güncellendi: https://app.blxchat.lol
🌐 API çağrısı: GET https://app.blxchat.lol/public/api/v1/...
```

**Hata (Eski URL):**
```
🌐 API çağrısı: GET https://call.betlabx.com/public/api/v1/...
```

### Network Sekmesi

F12 > Network:
- ✅ API çağrıları `app.blxchat.lol` üzerinden
- ❌ `call.betlabx.com` görünmemeli

## 🚨 Yaygın Sorunlar

### "Sunucudaki JSON dosyası eski"

**Çözüm:**
1. Admin panelinden güncelleyin
2. Veya manuel olarak düzenleyin

### "Build edilmemiş"

**Çözüm:**
1. `npm run build` çalıştırın
2. `dist/` klasörünü sunucuya yükleyin

### "Browser cache'inde eski dosya"

**Çözüm:**
1. Ctrl+Shift+Delete - Cache temizle
2. Ctrl+F5 - Sayfayı yenile

## ✅ Başarılı Çözüm

Eğer her şey doğru yapıldıysa:
- ✅ Console'da `🌐 Chatwoot Base URL güncellendi: https://app.blxchat.lol`
- ✅ Network'te `app.blxchat.lol` görünüyor
- ✅ `call.betlabx.com` hiçbir yerde görünmüyor

