# 🔧 call.betlabx.com Sorunu Çözümü

## 🔴 Sorun

Uygulama hala `call.betlabx.com` API'si ile haberleşiyor, ancak bu URL değiştirilmişti.

## ✅ Çözüm

### 1. Sunucudaki JSON Dosyasını Kontrol Et

**Sunucuda kontrol edin:**
```bash
# SSH ile sunucuya bağlanın
cat /var/www/html/public/inbox-settings.json | grep chatwootBaseUrl
```

**Beklenen:**
```json
"chatwootBaseUrl": "https://app.blxchat.lol"
```

**Eğer `call.betlabx.com` görüyorsanız:**
- Sunucudaki JSON dosyası eski
- Admin panelinden güncelleyin veya dosyayı manuel olarak düzenleyin

### 2. Admin Panelinden Güncelle

1. **Admin Paneline Giriş:**
   - URL: `https://api.blxchat.lol/admin`
   - Kullanıcı Adı: `admin`
   - Şifre: `admin123`

2. **Inbox'u Düzenle:**
   - `test232` inbox'unu düzenleyin
   - "Chatwoot Base URL (Domain)" alanını kontrol edin
   - **Eski:** `https://call.betlabx.com` veya `http://call.betlabx.com`
   - **Yeni:** `https://app.blxchat.lol`
   - "💾 Kaydet" butonuna tıklayın

### 3. Build ve Yükleme

**Yerel:**
```bash
cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"
npm run build
```

**Sunucuya Yükle:**
- `dist/` klasörü (yeni build)
- `public/inbox-settings.json` (güncellenmiş)

### 4. Browser Cache Temizle

1. **Ctrl+Shift+Delete** - Cache'i temizle
2. **Ctrl+F5** - Sayfayı yenile (hard refresh)
3. **Veya:** Incognito/Private mode'da test et

## 🔍 Kontrol

### Browser Console

F12 > Console'u açın ve şu logları kontrol edin:

**Başarılı:**
```
🔧 Chatwoot Base URL güncelleniyor: https://app.blxchat.lol
🌐 Chatwoot Base URL güncellendi: https://app.blxchat.lol
🌐 API çağrısı: GET https://app.blxchat.lol/public/api/v1/...
```

**Hata:**
```
🌐 API çağrısı: GET https://call.betlabx.com/public/api/v1/...
❌ BASE_URL boş!
```

### Network Sekmesi

F12 > Network sekmesinde:
- API çağrıları `https://app.blxchat.lol` üzerinden yapılmalı
- `call.betlabx.com` görünmemeli

## 🚨 Yaygın Sorunlar

### Sorun 1: "Sunucudaki JSON dosyası eski"

**Çözüm:**
1. Admin panelinden güncelleyin
2. Veya manuel olarak düzenleyin:
   ```bash
   # Sunucuda
   nano /var/www/html/public/inbox-settings.json
   # chatwootBaseUrl değerini değiştirin
   ```

### Sorun 2: "Build edilmemiş"

**Çözüm:**
1. Yerel olarak build edin: `npm run build`
2. `dist/` klasörünü sunucuya yükleyin
3. Browser cache'ini temizleyin

### Sorun 3: "Browser cache'inde eski dosya"

**Çözüm:**
1. Ctrl+Shift+Delete - Cache'i temizle
2. Ctrl+F5 - Sayfayı yenile
3. Incognito mode'da test et

### Sorun 4: "Admin panelinde placeholder görünüyor"

**Not:** Admin panelinde `call.betlabx.com` sadece placeholder (örnek) olarak görünür. Bu normaldir, gerçek değer JSON dosyasından okunur.

## 📋 Kontrol Listesi

- [ ] Sunucudaki `inbox-settings.json` dosyasında `chatwootBaseUrl` doğru mu?
- [ ] Admin panelinden `chatwootBaseUrl` güncellendi mi?
- [ ] Build edildi mi? (`npm run build`)
- [ ] `dist/` klasörü sunucuya yüklendi mi?
- [ ] Browser cache temizlendi mi?
- [ ] Console'da `🌐 Chatwoot Base URL güncellendi: https://app.blxchat.lol` görünüyor mu?
- [ ] Network sekmesinde `app.blxchat.lol` görünüyor mu?

## ✅ Başarılı Çözüm

Eğer her şey doğru yapıldıysa:

1. ✅ Console'da `🌐 Chatwoot Base URL güncellendi: https://app.blxchat.lol`
2. ✅ Network sekmesinde API çağrıları `app.blxchat.lol` üzerinden
3. ✅ `call.betlabx.com` hiçbir yerde görünmüyor
4. ✅ Mesajlar Chatwoot'a gidiyor

## 🔗 İlgili Dosyalar

- `public/inbox-settings.json` - Chatwoot Base URL burada
- `src/api/blxchat.js` - BASE_URL dinamik olarak ayarlanıyor
- `src/App.jsx` - Settings'ten BASE_URL okunuyor

## 📚 Ek Kaynaklar

- [Mixed Content Çözüm Rehberi](MIXED-CONTENT-COZUM.md)
- [Sunucu Güncelleme Rehberi](SUNUCU-GUNCELLEME.md)
- [Admin Panel Kullanımı](ADMIN-PANEL-KULLANIMI.md)

