# Debian Sunucuda Docker Olmadan Deploy Rehberi

Bu rehber, Betlabx Chat uygulamasını Debian sunucuda Docker kullanmadan deploy etmek için adımları içerir.

## Gereksinimler

- Debian sunucu (Ubuntu da çalışır)
- SSH erişimi
- Root veya sudo yetkisi

## Adım 1: Dosyaları Sunucuya Yükleyin

SFTP ile `pwa-chatwoot` klasörünü sunucuya yüklediyseniz, SSH ile bağlanın:

```bash
ssh kullanici@sunucu-ip
cd /path/to/pwa-chatwoot  # Dosyaları yüklediğiniz klasör
```

## Adım 2: Node.js Kurulumu

```bash
# Node.js 20.x kurulumu
curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
sudo apt-get install -y nodejs

# Versiyon kontrolü
node --version  # v20.x.x olmalı
npm --version
```

## Adım 3: Dependencies Kur ve Build Al

```bash
# Dependencies kur
npm install

# Production build al
npm run build

# Build başarılı mı kontrol et
ls -la dist/  # dist klasörü oluşmalı
```

## Adım 4A: Node.js ile Çalıştırma (Basit)

```bash
# Direkt çalıştır
npm start

# Arka planda çalıştırmak için (screen veya tmux ile)
screen -S betlabx-chat
npm start
# Ctrl+A, D ile çıkış

# Veya PM2 ile (önerilen - sürekli çalışır)
sudo npm install -g pm2
pm2 start server-static.js --name betlabx-chat
pm2 startup  # Sistem açılışta otomatik başlat
pm2 save     # Mevcut process'leri kaydet
```

**Port:** Varsayılan olarak `8080` portunda çalışır. Değiştirmek için:
```bash
PORT=3000 npm start
```

## Adım 4B: Nginx ile Çalıştırma (Önerilen)

### 4B.1: Nginx Kurulumu

```bash
sudo apt-get update
sudo apt-get install -y nginx
```

### 4B.2: Build Dosyalarını Nginx Klasörüne Kopyala

```bash
# Nginx web root klasörüne kopyala
sudo mkdir -p /var/www/betlabx-chat
sudo cp -r dist/* /var/www/betlabx-chat/
sudo chown -R www-data:www-data /var/www/betlabx-chat
```

### 4B.3: Nginx Konfigürasyonu

```bash
# Nginx config dosyası oluştur
sudo nano /etc/nginx/sites-available/betlabx-chat
```

Aşağıdaki içeriği yapıştırın (veya `nginx-production.conf` dosyasını kopyalayın):

```nginx
server {
    listen 80;
    server_name _;  # Domain adınızı buraya yazın
    root /var/www/betlabx-chat;
    index index.html;

    gzip on;
    gzip_vary on;
    gzip_min_length 1024;
    gzip_types text/plain text/css text/xml text/javascript application/x-javascript application/xml+rss application/json application/javascript;

    add_header X-Frame-Options "SAMEORIGIN" always;
    add_header X-Content-Type-Options "nosniff" always;
    add_header X-XSS-Protection "1; mode=block" always;

    location ~* \.(js|css|png|jpg|jpeg|gif|ico|svg|woff|woff2|ttf|eot)$ {
        expires 1y;
        add_header Cache-Control "public, immutable";
    }

    location ~* (service-worker\.js|manifest\.json)$ {
        expires -1;
        add_header Cache-Control "no-cache, no-store, must-revalidate";
    }

    location / {
        try_files $uri $uri/ /index.html;
    }
}
```

Config'i aktif et:
```bash
# Symbolic link oluştur
sudo ln -s /etc/nginx/sites-available/betlabx-chat /etc/nginx/sites-enabled/

# Default config'i devre dışı bırak (opsiyonel)
sudo rm /etc/nginx/sites-enabled/default

# Nginx config'i test et
sudo nginx -t

# Nginx'i yeniden başlat
sudo systemctl restart nginx

# Nginx durumunu kontrol et
sudo systemctl status nginx
```

## Adım 5: Firewall Ayarları

```bash
# UFW firewall varsa
sudo ufw allow 80/tcp   # HTTP
sudo ufw allow 8080/tcp # Node.js port (eğer Node.js kullanıyorsanız)

# Firewall durumunu kontrol et
sudo ufw status
```

## Adım 6: SSL/HTTPS Kurulumu (Opsiyonel - Önerilen)

Let's Encrypt ile ücretsiz SSL:

```bash
sudo apt-get install certbot python3-certbot-nginx

# SSL kurulumu (domain adınızı yazın)
sudo certbot --nginx -d chat.betlabx.com

# Otomatik yenileme test et
sudo certbot renew --dry-run
```

## Güncelleme

Yeni bir güncelleme geldiğinde:

```bash
cd /path/to/pwa-chatwoot

# Yeni dosyaları çek (SFTP ile yüklediyseniz)
# veya git pull yapın

# Dependencies güncelle
npm install

# Yeni build al
npm run build

# Nginx kullanıyorsanız:
sudo cp -r dist/* /var/www/betlabx-chat/

# Node.js kullanıyorsanız:
pm2 restart betlabx-chat
# veya
npm start
```

## PM2 ile Sürekli Çalıştırma (Önerilen)

```bash
# PM2 kurulumu
sudo npm install -g pm2

# Uygulamayı başlat
pm2 start server-static.js --name betlabx-chat

# PM2 komutları
pm2 list              # Çalışan uygulamaları listele
pm2 logs betlabx-chat # Logları görüntüle
pm2 restart betlabx-chat  # Yeniden başlat
pm2 stop betlabx-chat     # Durdur
pm2 delete betlabx-chat   # Sil

# Sistem açılışta otomatik başlat
pm2 startup
pm2 save
```

## Port Ayarları

Node.js server portunu değiştirmek için:

```bash
# .env dosyası oluştur
echo "PORT=3000" > .env

# Veya environment variable ile
PORT=3000 npm start
```

Nginx için port değiştirmek:
```nginx
listen 8080;  # nginx config dosyasında
```

## Troubleshooting

### Build hatası:
```bash
# Node.js versiyonunu kontrol et
node --version

# Cache temizle
rm -rf node_modules package-lock.json
npm install
npm run build
```

### Nginx 502 hatası:
```bash
# Nginx error loglarını kontrol et
sudo tail -f /var/log/nginx/error.log

# Nginx config'i test et
sudo nginx -t
```

### Port zaten kullanılıyor:
```bash
# Hangi process port kullanıyor kontrol et
sudo lsof -i :8080
sudo netstat -tulpn | grep 8080

# Process'i sonlandır
sudo kill -9 PID
```

### Dosya izinleri:
```bash
# Nginx için
sudo chown -R www-data:www-data /var/www/betlabx-chat
sudo chmod -R 755 /var/www/betlabx-chat
```

## Performans İpuçları

1. **Gzip compression**: Nginx config'de aktif (yukarıda var)
2. **Static file caching**: Nginx config'de aktif
3. **PM2 cluster mode**: Çoklu instance için
   ```bash
   pm2 start server-static.js -i max --name betlabx-chat
   ```

## Servisleri Yönetme

```bash
# Nginx
sudo systemctl status nginx
sudo systemctl restart nginx
sudo systemctl stop nginx
sudo systemctl start nginx

# PM2
pm2 list
pm2 logs
pm2 monit  # Monitoring dashboard
```

## Erişim

- Node.js: `http://sunucu-ip:8080`
- Nginx: `http://sunucu-ip` (veya domain adınız)

---

**Özet: En kolay yöntem**
1. `npm install && npm run build`
2. `sudo cp -r dist/* /var/www/betlabx-chat/`
3. Nginx config'i ayarla
4. `sudo systemctl restart nginx`

