# Portainer Deployment Rehberi

Bu rehber, Betlabx Chat uygulamasını Portainer üzerinde deploy etmek için gerekli adımları içerir.

## Gereksinimler

- Portainer kurulu ve çalışıyor olmalı
- Docker ve Docker Compose kurulu olmalı
- Uygulama dosyalarına erişim

## Deployment Yöntemleri

### Yöntem 1: Portainer Stack (Önerilen)

1. **Portainer'a giriş yapın** ve "Stacks" bölümüne gidin

2. **"Add stack"** butonuna tıklayın

3. **Stack adı verin**: `betlabx-chat`

4. **Build method'u seçin**:
   - "Web editor" veya "Repository" seçeneklerinden birini kullanın
   
5. **Eğer Repository kullanıyorsanız**:
   - Repository URL'sini girin
   - Branch'i seçin (örn: `main`)
   - Compose file path: `docker-compose.yml`

6. **Eğer Web editor kullanıyorsanız**:
   - `docker-compose.yml` dosyasını Portainer editörüne yapıştırın
   - Build method: "Build the image"

7. **Port mapping'i ayarlayın**:
   - `8080:80` şeklinde olmalı (veya istediğiniz port)
   - Container'da 80 portu açık kalmalı

8. **Environment variables** (opsiyonel):
   - `NODE_ENV=production` (otomatik eklenir)

9. **"Deploy the stack"** butonuna tıklayın

10. **Container durumunu kontrol edin**:
    - "Containers" bölümünden container'ın çalıştığını doğrulayın
    - Logs'u kontrol ederek hata olmadığından emin olun

### Yöntem 2: Dockerfile ile Manuel Build

1. **Dosyaları sunucuya yükleyin**:
   ```bash
   scp -r pwa-chatwoot/ user@server:/path/to/
   ```

2. **Portainer'dan "Images" bölümüne gidin**

3. **"Build a new image"** butonuna tıklayın

4. **Build method**: "Upload"

5. **Dockerfile'ı yükleyin** ve build context'i seçin

6. **Image adı**: `betlabx-chat:latest`

7. **Build başlatın**

8. **Container oluşturun**:
   - "Containers" -> "Add container"
   - Image: `betlabx-chat:latest`
   - Name: `betlabx-chat`
   - Port mapping: `8080:80`
   - Restart policy: `unless-stopped`

### Yöntem 3: Git Repository'den Otomatik Build

1. **Git repository'nize dosyaları push edin**

2. **Portainer'da "Stacks" -> "Add stack"**

3. **Repository URL'sini girin**

4. **Auto-update'i etkinleştirin** (opsiyonel):
   - Webhook URL'i alın
   - Git repository'nize webhook ekleyin
   - Her push'ta otomatik rebuild yapılır

## Portainer'da Stack Oluşturma Adımları (Detaylı)

1. Portainer ana sayfasından **"Stacks"** menüsüne gidin

2. **"+ Add stack"** butonuna tıklayın

3. **Stack name**: `betlabx-chat`

4. **Build method** seçimi:
   
   **A) Web editor:**
   - "Web editor" seçin
   - `docker-compose.yml` dosyasının içeriğini yapıştırın
   - "Build the image" seçeneğini işaretleyin

   **B) Git repository:**
   - "Repository" seçin
   - Repository URL: `https://github.com/your-username/your-repo.git`
   - Reference: `main` veya `master`
   - Compose path: `docker-compose.yml`

5. **Environment variables** (gerekirse):
   ```
   VITE_BASE_URL=https://call.betlabx.com
   VITE_INBOX_IDENTIFIER=mdo5jWFdoJ6mnhij3FkBPJb3
   ```

6. **Deploy the stack** butonuna tıklayın

7. Build işlemi tamamlanana kadar bekleyin (genellikle 2-5 dakika)

8. **Container durumunu kontrol edin**:
   - "Stacks" -> "betlabx-chat" -> "Containers"
   - Container'ın "Running" durumunda olduğunu doğrulayın

9. **Uygulamaya erişim**:
   - `http://your-server-ip:8080`
   - Veya domain ile: `http://betlabx-chat.yourdomain.com:8080`

## Port Ayarı

`docker-compose.yml` dosyasındaki port mapping'i değiştirerek farklı bir port kullanabilirsiniz:

```yaml
ports:
  - "9090:80"  # Host port 9090, container port 80
```

## Environment Variables

Production'da environment variables kullanmak için:

1. `docker-compose.yml` dosyasına ekleyin:
```yaml
environment:
  - VITE_BASE_URL=https://call.betlabx.com
  - VITE_INBOX_IDENTIFIER=mdo5jWFdoJ6mnhij3FkBPJb3
```

2. Veya Portainer'da Stack'i düzenlerken "Environment variables" bölümüne ekleyin

**Not**: Vite build-time variables olduğu için, build sırasında environment variables'ları okur. Production'da değişiklik yapmak için yeniden build gerekir.

## Log Kontrolü

Portainer'da logları kontrol etmek için:

1. "Stacks" -> "betlabx-chat" -> "Containers" -> Container adına tıklayın
2. "Logs" sekmesine gidin
3. Gerçek zamanlı logları görebilirsiniz

## Troubleshooting

### Container başlamıyor:
- Logs'u kontrol edin
- Port'un başka bir servis tarafından kullanılmadığından emin olun
- Dockerfile ve docker-compose.yml dosyalarını kontrol edin

### 502 Bad Gateway:
- Container'ın çalıştığını doğrulayın
- Port mapping'in doğru olduğunu kontrol edin
- Nginx konfigürasyonunu kontrol edin

### Build hatası:
- Node.js versiyonunu kontrol edin (20-alpine kullanılıyor)
- Package.json'daki dependencies'leri kontrol edin
- Build logs'u inceleyin

## Güncelleme

Stack'i güncellemek için:

1. "Stacks" -> "betlabx-chat" -> "Editor" 
2. docker-compose.yml'i güncelleyin
3. "Update the stack" butonuna tıklayın

Veya Git repository kullanıyorsanız:
1. Kodları güncelleyin ve push edin
2. Portainer'da "Pull and redeploy" butonuna tıklayın

## Backup

Container'ın backup'ını almak için:

1. "Volumes" bölümünden volume'ları export edin
2. Image'ı export edin: "Images" -> Image'a tıklayın -> "Export"

## Silme

Stack'i silmek için:

1. "Stacks" -> "betlabx-chat" -> "Remove"
2. Onaylayın
3. (Opsiyonel) Image'ı da silmek için: "Images" -> Image'ı seçin -> "Remove"

