# 🌐 Domain ile Erişim Test Rehberi

## ✅ Yapılan Düzeltmeler

1. **.htaccess** - SPA routing düzeltildi
2. **JSON dosyaları** - Root'tan çağrılan JSON'lar `public/` klasörüne yönlendiriliyor
3. **Vite config** - Base path ve build ayarları eklendi

## 🔍 Test Adımları

### 1. Apache mod_rewrite Kontrolü

Apache'de `mod_rewrite` aktif olmalı:

```bash
# Kontrol et
apache2ctl -M | grep rewrite

# Eğer yoksa aktif et
sudo a2enmod rewrite
sudo systemctl restart apache2
```

### 2. .htaccess Dosyasının Konumu

`.htaccess` dosyası proje root'unda olmalı:
```
/path/to/pwa-chatwoot/.htaccess
```

### 3. Apache AllowOverride Kontrolü

Apache config'de `AllowOverride All` olmalı:

```apache
<Directory /path/to/pwa-chatwoot>
    AllowOverride All
    Require all granted
</Directory>
```

### 4. Build ve Test

```bash
# Build et
npm run build

# Test et
# Tarayıcıda: http://domain.com/test232
```

## 🐛 Sorun Giderme

### Sorun: "404 Not Found" veya "File not found"

**Çözüm:**
1. `.htaccess` dosyasının root'ta olduğundan emin olun
2. Apache error log'unu kontrol edin:
   ```bash
   tail -f /var/log/apache2/error.log
   ```
3. `mod_rewrite` aktif mi kontrol edin

### Sorun: "Internal Server Error"

**Çözüm:**
1. Apache error log'unu kontrol edin
2. `.htaccess` syntax hatası olabilir
3. Apache config'de `AllowOverride All` olduğundan emin olun

### Sorun: JSON dosyaları yüklenmiyor

**Çözüm:**
1. `public/inbox-settings.json` dosyasının var olduğundan emin olun
2. Tarayıcı console'da network sekmesini kontrol edin
3. JSON dosyalarına direkt erişimi test edin:
   - `http://domain.com/inbox-settings.json`
   - `http://domain.com/public/inbox-settings.json`

### Sorun: Sayfa açılıyor ama inbox ID algılanmıyor

**Çözüm:**
1. Tarayıcı console'u açın (F12)
2. `window.location.pathname` değerini kontrol edin
3. `getInboxFromUrl()` fonksiyonunun doğru çalıştığını kontrol edin

## 📋 Kontrol Listesi

- [ ] Apache `mod_rewrite` aktif
- [ ] `.htaccess` dosyası root'ta
- [ ] Apache config'de `AllowOverride All`
- [ ] `npm run build` yapıldı
- [ ] `dist/` klasörü oluşturuldu
- [ ] `public/` klasörü mevcut
- [ ] JSON dosyaları `public/` klasöründe
- [ ] Domain DNS ayarları doğru
- [ ] Apache virtual host doğru yapılandırıldı

## 🔧 Apache Virtual Host Örneği

Eğer virtual host yapılandırmanız yoksa:

```apache
<VirtualHost *:80>
    ServerName domain.com
    ServerAlias www.domain.com
    
    DocumentRoot /path/to/pwa-chatwoot
    
    <Directory /path/to/pwa-chatwoot>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
    
    ErrorLog ${APACHE_LOG_DIR}/blxchat-error.log
    CustomLog ${APACHE_LOG_DIR}/blxchat-access.log combined
</VirtualHost>
```

Sonra:
```bash
sudo a2ensite blxchat.conf
sudo systemctl reload apache2
```

## 🚀 Hızlı Test

1. **Build:**
   ```bash
   npm run build
   ```

2. **Test URL'leri:**
   - `http://domain.com/` - Ana sayfa
   - `http://domain.com/test232` - Test inbox
   - `http://domain.com/admin/` - Admin panel
   - `http://domain.com/inbox-settings.json` - JSON dosyası

3. **Console Kontrolü:**
   - F12 → Console
   - `window.location.pathname` değerini kontrol edin
   - `getInboxFromUrl()` log'larını kontrol edin

## 📝 Notlar

- Path bilgisi korunur (internal rewrite kullanılıyor)
- JSON dosyaları otomatik olarak `public/` klasöründen serve edilir
- SPA routing tüm path'ler için çalışır

**Başarılar! 🎉**

