# FCM Cloud Messaging API (Legacy) Etkinleştirme Rehberi

## Sorun

Firebase Console'da "Cloud Messaging API (Legacy) Disabled" görüyorsunuz. Bu, FCM Server Key'i almak için gerekli olan API'nin devre dışı olduğu anlamına gelir.

## Çözüm: API'yi Etkinleştirme

### Yöntem 1: Google Cloud Console'dan (Önerilen)

1. **Google Cloud Console'a gidin**:
   - https://console.cloud.google.com/
   - Firebase projenizle aynı Google hesabıyla giriş yapın

2. **Projenizi seçin**:
   - Üst kısımdaki proje seçici menüden Firebase projenizi seçin
   - Proje adı genellikle Firebase proje ID'si ile aynıdır (örn: `blxchat`)

3. **API Library'ye gidin**:
   - Sol menüden "APIs & Services" > "Library" seçin
   - Veya direkt link: https://console.cloud.google.com/apis/library

4. **FCM API'yi bulun**:
   - Arama kutusuna "Firebase Cloud Messaging API" veya "FCM API" yazın
   - "Firebase Cloud Messaging API" sonucuna tıklayın

5. **API'yi etkinleştirin**:
   - "Enable" butonuna tıklayın
   - API etkinleştirildikten sonra "API enabled" mesajı görünecek

6. **Firebase Console'a geri dönün**:
   - https://console.firebase.google.com/
   - Projenizi seçin
   - "Project Settings" > "Cloud Messaging" sekmesine gidin
   - Artık "Cloud Messaging API (Legacy)" bölümünde "Server key" görünecek

### Yöntem 2: Firebase Console'dan

1. **Firebase Console'a gidin**:
   - https://console.firebase.google.com/
   - Projenizi seçin

2. **Project Settings'e gidin**:
   - Sol üst köşedeki ⚙️ (Settings) ikonuna tıklayın
   - "Project settings" seçin

3. **Cloud Messaging sekmesine gidin**:
   - "Cloud Messaging" sekmesine tıklayın

4. **API'yi etkinleştir**:
   - "Cloud Messaging API (Legacy)" bölümünde "Enable" butonuna tıklayın
   - Eğer buton görünmüyorsa, Google Cloud Console'a yönlendirileceksiniz

### Yöntem 3: Direkt Link

Aşağıdaki linki kullanarak direkt API sayfasına gidebilirsiniz (proje ID'nizi değiştirin):

```
https://console.cloud.google.com/apis/library/fcm.googleapis.com?project=YOUR_PROJECT_ID
```

Örnek (blxchat projesi için):
```
https://console.cloud.google.com/apis/library/fcm.googleapis.com?project=blxchat
```

## Server Key'i Alma

API etkinleştirildikten sonra:

1. **Firebase Console** > **Project Settings** > **Cloud Messaging** sekmesine gidin
2. **"Cloud Messaging API (Legacy)"** bölümünde **"Server key"** değerini kopyalayın
3. Bu key'i admin panelinde **"FCM Server Key"** alanına yapıştırın

## Alternatif: FCM v1 API (İleri Seviye)

Eğer Legacy API'yi kullanamıyorsanız, yeni FCM v1 API'sini kullanabilirsiniz. Ancak bu daha karmaşık bir yapılandırma gerektirir:

1. **Service Account oluşturun**:
   - Google Cloud Console > IAM & Admin > Service Accounts
   - Yeni service account oluşturun
   - "Firebase Cloud Messaging Admin" rolünü verin
   - JSON key dosyasını indirin

2. **Kod değişiklikleri gerekir**:
   - `fcm-send.php` dosyasını FCM v1 API kullanacak şekilde güncellemek gerekir
   - OAuth2 authentication kullanılır
   - Daha karmaşık ama daha güvenli

**Not:** Şu an için Legacy API'yi etkinleştirmek daha kolay ve mevcut kodumuzla uyumludur.

## Sorun Giderme

### "API enabled" görünüyor ama Server key hala görünmüyor

1. Sayfayı yenileyin (F5)
2. Firebase Console'dan çıkıp tekrar giriş yapın
3. Birkaç dakika bekleyin (API etkinleştirme işlemi bazen biraz zaman alabilir)

### "Permission denied" hatası alıyorum

1. Google Cloud Console'da projenin sahibi olduğunuzdan emin olun
2. Firebase Console'da projenin sahibi olduğunuzdan emin olun
3. Gerekirse proje sahibinden izin isteyin

### API'yi etkinleştiremiyorum

1. Google Cloud Console'da projenin aktif olduğundan emin olun
2. Billing hesabının bağlı olduğundan emin olun (FCM ücretsizdir, ancak bazı durumlarda billing gerekebilir)
3. Farklı bir tarayıcı veya gizli mod deneyin

## Test Etme

API etkinleştirildikten ve Server key eklendikten sonra:

1. Admin panelinde bir inbox için FCM ayarlarını yapın
2. "🔥 FCM Test" butonuna tıklayın
3. Bildirimin geldiğini kontrol edin

## Önemli Notlar

- **FCM ücretsizdir**: Cloud Messaging API kullanımı ücretsizdir
- **Server key güvenli tutulmalı**: Server key'i asla public repository'lere commit etmeyin
- **Rate limits**: FCM'in rate limit'leri vardır, ancak normal kullanım için yeterlidir
- **Legacy API**: Legacy API hala desteklenmektedir, ancak gelecekte v1 API'ye geçiş önerilebilir

## Yardım

Sorun devam ederse:
1. Firebase Console'da "Support" bölümüne bakın
2. Google Cloud Console'da "Support" bölümüne bakın
3. Firebase dokümantasyonunu kontrol edin: https://firebase.google.com/docs/cloud-messaging

