# FCM Kullanıma Hazır - Adım Adım Rehber

## ✅ Yapılanlar

1. ✅ FCM Server Key admin-config.json'a eklendi
2. ✅ FCM ayarları admin panelinde inbox düzenleme formuna eklendi
3. ✅ Firebase Config ve VAPID Key alanları hazır
4. ✅ Backend API endpoint'leri hazır (`/api/fcm-token.php`, `/api/fcm-send.php`)

## 📋 Şimdi Yapılacaklar

### 1. Frontend'i Build Etmek (ÖNEMLİ!)

Firebase SDK'yı kullanmak için frontend'i build etmeniz gerekiyor:

```bash
cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"
npm install
npm run build
```

Bu işlem:
- Firebase SDK'yı yükler (`npm install`)
- Frontend'i production için build eder (`npm run build`)
- `dist/` klasörüne build edilmiş dosyaları oluşturur

### 2. Inbox FCM Ayarlarını Yapmak

Admin panelinde:

1. **Inbox düzenleme formuna gidin**
2. **"Logo/Icon URL" alanının altında "🔔 FCM Ayarları" bölümünü bulun**
3. **"FCM Bildirimleri Etkinleştir" checkbox'ını işaretleyin**
4. **Firebase Config'i yapıştırın:**
   ```json
   {
     "apiKey": "AIzaSyAbAsgluF9RiapMk8iN0B3lXmWtC2BZ224",
     "authDomain": "blxchat.firebaseapp.com",
     "projectId": "blxchat",
     "storageBucket": "blxchat.firebasestorage.app",
     "messagingSenderId": "476584355021",
     "appId": "1:476584355021:web:c7f2c4b6304ba6d020f584"
   }
   ```
5. **VAPID Key'i yapıştırın:**
   ```
   BBCUFwL8bPQCMORFr1_dFITRulRR5b7dU-1GLPsQtKFEBLIbJavMal9IAK6ZnCLEbsrdykPyUY_-37WY3lkZFrU
   ```
6. **"💾 Kaydet" butonuna tıklayın**

### 3. Test Etmek

#### Adım 1: Sayfayı Açın

1. Inbox'unuzun test URL'sine gidin (örn: `https://api.blxchat.lol/test1234`)
2. Tarayıcı konsolunu açın (F12)
3. Bildirim iznini verin (eğer istenirse)

#### Adım 2: FCM Token Kontrolü

Konsolda şu log'ları arayın:

```
🔥 FCM: Initialize ediliyor...
✅ FCM: Firebase initialize edildi
✅ FCM: Messaging initialize edildi
✅ FCM: Token alındı: ...
✅ FCM: Token backend'e gönderildi
```

#### Adım 3: Token'ın Kaydedildiğini Kontrol Edin

`public/fcm-tokens.json` dosyası otomatik oluşturulacak. İçeriği şöyle olmalı:

```json
{
  "test1234": [
    {
      "token": "fcm-token-buraya",
      "url": "https://api.blxchat.lol/test1234",
      "created_at": "2025-01-10 12:00:00",
      "updated_at": "2025-01-10 12:00:00"
    }
  ]
}
```

#### Adım 4: Test Bildirimi Gönderin

1. Admin panelinde inbox listesine gidin
2. "🔥 FCM Test" butonuna tıklayın
3. Bildirimin geldiğini kontrol edin

### 4. Dosya İzinlerini Kontrol Edin

Sunucuda `public/fcm-tokens.json` dosyasının yazılabilir olduğundan emin olun:

```bash
# Linux'ta
chmod 666 public/fcm-tokens.json
chown www-data:www-data public/fcm-tokens.json
```

### 5. Sunucuya Dosyaları Yükleyin

Build işlemi tamamlandıktan sonra sunucuya yüklemeniz gereken dosyalar:

- `dist/` klasörü (build edilmiş frontend)
- `public/firebase-messaging-sw.js` (FCM Service Worker)
- `public/api/fcm-token.php` (Token kaydetme endpoint)
- `public/api/fcm-send.php` (Bildirim gönderme endpoint)
- `admin/index.php` (Güncellenmiş admin panel)
- `src/services/fcm.js` (FCM servis dosyası - build edilecek)

## 🔍 Kontrol Listesi

- [ ] `npm install` çalıştırıldı mı?
- [ ] `npm run build` çalıştırıldı mı?
- [ ] `dist/` klasörü oluşturuldu mu?
- [ ] FCM Server Key `admin-config.json`'da var mı?
- [ ] Inbox FCM ayarları yapıldı mı?
- [ ] Firebase Config ve VAPID Key girildi mi?
- [ ] Sayfa açıldığında token alındı mı?
- [ ] `fcm-tokens.json` dosyası oluşturuldu mu?
- [ ] Test bildirimi gönderildi mi?
- [ ] Bildirim geldi mi?

## 🚀 Hızlı Başlangıç

### Lokal Test (Development)

```bash
# 1. Firebase SDK'yı yükle
npm install

# 2. Development server'ı başlat
npm run dev

# 3. Tarayıcıda aç: http://localhost:5173/test1234
# 4. Konsolu kontrol et
# 5. Admin panelden test bildirimi gönder
```

### Production Build

```bash
# 1. Build et
npm run build

# 2. dist/ klasörünü sunucuya yükle
# 3. public/ klasörünü sunucuya yükle
# 4. admin/ klasörünü sunucuya yükle
# 5. .htaccess dosyasını sunucuya yükle
```

## 📱 Mobil Test

1. **HTTPS kullanın** (mobil bildirimler için gerekli)
2. **Sayfayı açın** ve bildirim iznini verin
3. **Token'ın alındığını kontrol edin** (konsol log'ları)
4. **Test bildirimi gönderin**
5. **Bildirimin geldiğini kontrol edin**

## ❓ Sorun Giderme

### "FCM: Config ayarlanamadı" hatası
→ Firebase Config JSON'u kontrol edin, doğru formatta olmalı

### "FCM: VAPID key eksik" hatası
→ VAPID Key'in girildiğinden emin olun

### "FCM: Token alınamadı" hatası
→ Bildirim izninin verildiğinden emin olun
→ HTTPS kullandığınızdan emin olun (localhost hariç)
→ Service Worker'ın kayıtlı olduğundan emin olun

### "Bildirim gelmiyor" hatası
→ FCM Server Key'in `admin-config.json`'da olduğundan emin olun
→ Token'ın `fcm-tokens.json`'da kayıtlı olduğundan emin olun
→ FCM API'nin Google Cloud Console'da etkin olduğundan emin olun

## 🎉 Başarılı Test

Eğer her şey çalışıyorsa:

1. ✅ Token alındı ve kaydedildi
2. ✅ Test bildirimi gönderildi
3. ✅ Bildirim geldi (hem sayfa açıkken hem kapalıyken)
4. ✅ Bildirim tıklandığında sayfa açıldı

## 📞 Sonraki Adımlar

1. **Chatwoot Webhook Entegrasyonu**: Yeni mesaj geldiğinde otomatik bildirim gönderme
2. **Monitoring**: Token sayısını ve bildirim başarı oranını izleme
3. **Optimizasyon**: Bildirim içeriklerini özelleştirme

