# FCM Test Adımları

## 1. Build İşlemi

FCM entegrasyonu için önce frontend'i build etmeniz gerekiyor:

```bash
cd pwa-chatwoot
npm install
npm run build
```

Bu işlem:
- Firebase SDK'yı yükler
- Frontend'i production için build eder
- `dist/` klasörüne build edilmiş dosyaları oluşturur

## 2. FCM Server Key Kontrolü

Admin panelinde "🔧 BLXChat API Ayarları" bölümünde:
- FCM Server Key'in girildiğinden emin olun
- "💾 API Ayarlarını Kaydet" butonuna tıklayın
- `admin-config.json` dosyasında `fcm_server_key` olduğunu kontrol edin

## 3. Inbox FCM Ayarları

Inbox düzenleme formunda:
- "FCM Bildirimleri Etkinleştir" checkbox'ını işaretleyin
- Firebase Config JSON'unu yapıştırın
- VAPID Key'i yapıştırın
- "💾 Kaydet" butonuna tıklayın

## 4. Test Adımları

### Adım 1: Sayfayı Açın

1. Inbox'unuzun test URL'sine gidin (örn: `https://your-domain.com/test1234`)
2. Tarayıcı konsolunu açın (F12)
3. Bildirim iznini verin (eğer istenirse)

### Adım 2: FCM Token Kontrolü

Konsolda şu log'ları arayın:

```
🔥 FCM: Initialize ediliyor...
✅ FCM: Firebase initialize edildi
✅ FCM: Messaging initialize edildi
✅ FCM: Token alındı: ...
✅ FCM: Token backend'e gönderildi
```

### Adım 3: Token'ın Kaydedildiğini Kontrol Edin

`public/fcm-tokens.json` dosyasını kontrol edin:

```json
{
  "test1234": [
    {
      "token": "fcm-token-buraya",
      "url": "https://your-domain.com/test1234",
      "created_at": "2025-01-10 12:00:00",
      "updated_at": "2025-01-10 12:00:00"
    }
  ]
}
```

### Adım 4: Test Bildirimi Gönderin

1. Admin panelinde inbox listesine gidin
2. "🔥 FCM Test" butonuna tıklayın
3. Bildirimin geldiğini kontrol edin

## 5. Sorun Giderme

### Token alınamıyor

**Kontrol listesi:**
- ✅ Firebase Config doğru mu?
- ✅ VAPID Key doğru mu?
- ✅ HTTPS kullanıyor musunuz? (localhost hariç)
- ✅ Bildirim izni verildi mi?
- ✅ Service Worker kayıtlı mı?

**Konsol log'larını kontrol edin:**
- `❌ FCM: Config ayarlanamadı` → Firebase Config hatalı
- `❌ FCM: VAPID key eksik` → VAPID Key girilmemiş
- `⚠️ FCM: Bildirim izni verilmemiş` → İzin verilmemiş

### Bildirim gelmiyor

**Kontrol listesi:**
- ✅ FCM Server Key `admin-config.json`'da var mı?
- ✅ Token `fcm-tokens.json`'da kayıtlı mı?
- ✅ FCM API etkinleştirildi mi? (Google Cloud Console)
- ✅ Test bildirimi gönderildi mi?

**Kontrol edin:**
- `public/fcm-tokens.json` dosyasında token var mı?
- Admin panelden "🔥 FCM Test" butonuna tıkladığınızda hata mesajı var mı?
- `public/api/fcm-send.php` dosyası erişilebilir mi?

### Service Worker hatası

**Kontrol listesi:**
- ✅ `firebase-messaging-sw.js` dosyası `/public/` klasöründe mi?
- ✅ Service Worker kayıtlı mı? (Konsol: `✅ Service Worker kayıtlı`)
- ✅ HTTPS kullanıyor musunuz?

**Çözüm:**
1. Tarayıcı cache'ini temizleyin
2. Service Worker'ı yeniden kaydedin
3. Sayfayı yenileyin

## 6. Production Deployment

### Build ve Deploy

```bash
# Build
npm run build

# Dosyaları sunucuya yükleyin
# - dist/ klasörü
# - public/ klasörü (fcm-tokens.json dahil)
# - admin/ klasörü
# - .htaccess dosyası
```

### Sunucuda Kontroller

1. **PHP Extension'ları:**
   - `curl` extension aktif mi?
   - `json` extension aktif mi?

2. **Dosya İzinleri:**
   - `public/fcm-tokens.json` dosyası yazılabilir mi?
   - `public/api/` klasörü erişilebilir mi?

3. **HTTPS:**
   - HTTPS kullanılıyor mu?
   - SSL sertifikası geçerli mi?

## 7. Başarılı Test Sonucu

Eğer her şey çalışıyorsa:

1. ✅ Token alındı ve kaydedildi
2. ✅ Test bildirimi gönderildi
3. ✅ Bildirim geldi (hem sayfa açıkken hem kapalıyken)
4. ✅ Bildirim tıklandığında sayfa açıldı

## 8. Sonraki Adımlar

### Chatwoot Webhook Entegrasyonu

Chatwoot webhook'unda yeni mesaj geldiğinde FCM bildirimi göndermek için:

1. Chatwoot'ta webhook URL'i ayarlayın: `https://your-domain.com/api/chatwoot-webhook.php`
2. Webhook handler'da FCM bildirimi gönderin
3. Test edin

### Monitoring

- Token sayısını izleyin (`fcm-tokens.json`)
- Bildirim başarı oranını izleyin
- Hataları log'layın

## Yardım

Sorun devam ederse:
1. Konsol log'larını kontrol edin
2. `fcm-tokens.json` dosyasını kontrol edin
3. `public/api/fcm-send.php` dosyasını test edin
4. Firebase Console'da API kullanımını kontrol edin

