# 🚀 BLXChat Portainer Kurulum Rehberi

## 📋 Adım Adım Kurulum

### 1️⃣ Dosyaları Hazırlama

#### Seçenek A: Git Repository Kullanıyorsanız
- Projeyi Git'e push edin
- Repository URL'ini not edin

#### Seçenek B: Manuel Dosya Yükleme
- Tüm proje dosyalarını bir klasörde toplayın
- Portainer'da upload edebilirsiniz

### 2️⃣ Portainer'a Giriş

1. Portainer web arayüzüne giriş yapın
2. Sol menüden **Stacks** seçeneğine tıklayın
3. **Add stack** butonuna tıklayın

### 3️⃣ Stack Oluşturma

#### Stack Bilgileri:
- **Name**: `blxchat` (veya istediğiniz isim)
- **Build method**: Seçeneklerden birini seçin:

---

### 🔧 YÖNTEM 1: Web Editor ile (En Kolay)

1. **Build method**: **Web editor** seçin
2. Aşağıdaki `docker-compose.yml` içeriğini kopyalayıp yapıştırın:

```yaml
version: '3.8'

services:
  blxchat:
    build:
      context: .
      dockerfile: Dockerfile
    image: blxchat:latest
    container_name: blxchat
    restart: unless-stopped
    ports:
      - "8080:80"
    volumes:
      - ./public:/var/www/html/public
    environment:
      - NODE_ENV=production
    networks:
      - blxchat-network
    healthcheck:
      test: ["CMD-SHELL", "curl -f http://localhost/ || exit 1"]
      interval: 30s
      timeout: 10s
      retries: 3
      start_period: 40s

networks:
  blxchat-network:
    driver: bridge
```

3. **⚠️ ÖNEMLİ**: Build context için dosyaları yüklemeniz gerekiyor:
   - **Upload files** butonuna tıklayın
   - Şu dosyaları seçin:
     - `Dockerfile`
     - `package.json`
     - `package-lock.json`
     - `vite.config.js`
     - `index.html`
     - `src/` klasörü (tüm içeriği)
     - `admin/` klasörü (tüm içeriği)
     - `public/` klasörü (tüm içeriği)
     - `.htaccess`
     - `.dockerignore`

4. **Deploy the stack** butonuna tıklayın

---

### 🔧 YÖNTEM 2: Git Repository ile (Önerilen)

1. **Build method**: **Repository** seçin
2. **Repository URL**: Git repository URL'inizi girin
   - Örnek: `https://github.com/kullanici/blxchat.git`
3. **Compose path**: `docker-compose.yml`
4. **Reference**: `main` veya `master` (branch adı)
5. **Deploy the stack** butonuna tıklayın

---

### 🔧 YÖNTEM 3: Manuel Build (SSH Erişimi Varsa)

Eğer Portainer'da build yapamıyorsanız, önce image'ı manuel build edin:

```bash
# SSH ile sunucuya bağlanın
cd /path/to/pwa-chatwoot

# Image'ı build edin
docker build -t blxchat:latest .

# Portainer'da sadece image'ı kullanın
```

Sonra Portainer'da:
1. **Build method**: **Web editor**
2. `docker-compose.yml` içinde `build:` yerine `image: blxchat:latest` kullanın:

```yaml
services:
  blxchat:
    image: blxchat:latest  # build: kısmını kaldırın
    container_name: blxchat
    # ... diğer ayarlar
```

---

## ⚙️ Kurulum Sonrası Ayarlar

### 1. Port Kontrolü

Varsayılan port: **8080**

Port değiştirmek için:
- Portainer'da **Stacks** > `blxchat` > **Editor**
- `ports:` kısmını değiştirin:
  ```yaml
  ports:
    - "3000:80"  # 3000 portunu kullan
  ```
- **Update the stack** butonuna tıklayın

### 2. İlk Giriş

1. Tarayıcıda açın: `http://SUNUCU_IP:8080/admin/`
2. **Varsayılan admin şifresi**: `admin123`
3. **⚠️ HEMEN DEĞİŞTİRİN!**

### 3. API Ayarları (Opsiyonel)

1. Admin panelinde **BLXChat API Ayarları** bölümüne gidin
2. API bilgilerinizi girin:
   - **BLXChat API URL**: `https://call.betlabx.com` (veya sizin URL)
   - **API Access Token**: Chatwoot'tan aldığınız token
   - **Account ID**: Genellikle `1`
3. **💾 API Ayarlarını Kaydet** butonuna tıklayın

### 4. İlk Inbox Oluşturma

1. **Yeni Inbox Ekle** bölümüne gidin
2. Formu doldurun:
   - **Inbox ID**: `test` (veya istediğiniz)
   - **Firma/App Adı**: `Test Chat`
   - Diğer ayarlar opsiyonel
3. **Inbox Ekle** butonuna tıklayın

### 5. Test Etme

- **Chat Uygulaması**: `http://SUNUCU_IP:8080/test`
- **Admin Panel**: `http://SUNUCU_IP:8080/admin/`

---

## 🔍 Sorun Giderme

### Container Başlamıyor

1. **Stacks** > `blxchat` > **Logs** sekmesine gidin
2. Hata mesajlarını kontrol edin
3. Yaygın sorunlar:
   - **Port çakışması**: Başka bir port kullanın
   - **Build hatası**: Dosyaların tamamını yüklediğinizden emin olun
   - **Disk alanı**: Yeterli alan olduğundan emin olun

### Build Hatası

**Hata**: `Cannot find Dockerfile`
- **Çözüm**: Dockerfile dosyasını build context'e eklediğinizden emin olun

**Hata**: `npm ci failed`
- **Çözüm**: `package.json` ve `package-lock.json` dosyalarını kontrol edin

**Hata**: `COPY failed`
- **Çözüm**: Tüm gerekli dosyaları yüklediğinizden emin olun

### Uygulama Açılmıyor

1. Container durumunu kontrol edin:
   - **Containers** > `blxchat` > Durum **Running** olmalı
2. Port'u kontrol edin:
   - `http://localhost:8080` çalışıyor mu?
3. Logları kontrol edin:
   - **Logs** sekmesinde Apache başlangıç mesajlarını görüyor musunuz?

### Permission Hatası

JSON dosyalarına yazma izni yoksa:

```bash
# SSH ile sunucuya bağlanın
cd /path/to/pwa-chatwoot/public
chmod 666 *.json
chmod 777 logos
```

---

## 📦 Güncelleme

### Yeni Versiyon Yükleme

1. **Stacks** > `blxchat` > **Editor**
2. `docker-compose.yml` dosyasını güncelleyin
3. **Update the stack** butonuna tıklayın
4. Veya **Recreate** butonunu kullanın

### Veri Yedekleme

Önemli dosyalar:
- `public/inbox-settings.json`
- `public/users.json`
- `public/companies.json`
- `public/admin-config.json`
- `public/logos/` klasörü

Yedek almak için:
```bash
# SSH ile
cd /path/to/pwa-chatwoot
tar -czf backup-$(date +%Y%m%d).tar.gz public/
```

---

## 🌐 Domain Kullanma (Opsiyonel)

Eğer domain kullanmak istiyorsanız:

### Nginx Reverse Proxy

```nginx
server {
    listen 80;
    server_name chat.example.com;

    location / {
        proxy_pass http://localhost:8080;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
    }
}
```

### Traefik Labels

`docker-compose.yml` içine ekleyin:

```yaml
services:
  blxchat:
    # ... mevcut ayarlar
    labels:
      - "traefik.enable=true"
      - "traefik.http.routers.blxchat.rule=Host(`chat.example.com`)"
      - "traefik.http.routers.blxchat.entrypoints=web"
      - "traefik.http.services.blxchat.loadbalancer.server.port=80"
```

---

## ✅ Kurulum Kontrol Listesi

- [ ] Portainer'a giriş yapıldı
- [ ] Stack oluşturuldu
- [ ] Container çalışıyor (Running)
- [ ] Port 8080'de erişilebiliyor
- [ ] Admin paneli açılıyor (`/admin/`)
- [ ] Admin şifresi değiştirildi
- [ ] API ayarları yapıldı (opsiyonel)
- [ ] İlk inbox oluşturuldu
- [ ] Chat uygulaması test edildi

---

## 🆘 Yardım

Sorun yaşarsanız:
1. Container loglarını kontrol edin
2. Portainer event loglarını inceleyin
3. Disk alanı ve RAM kullanımını kontrol edin
4. Port çakışması olup olmadığını kontrol edin

**Başarılar! 🎉**

