# 🔧 localhost'ta call.betlabx.com Sorunu Çözümü

## 🔴 Sorun

Localhost'ta (`http://localhost:5173/test232`) çalışırken:
- ❌ `inbox-settings.json` dosyası yüklenemiyor (HTML dönüyor)
- ❌ `BASE_URL` boş kalıyor veya `call.betlabx.com` kullanılıyor
- ❌ API çağrıları `call.betlabx.com` üzerinden yapılıyor

## ✅ Çözüm

### 1. VITE_BASE_URL Kaldırıldı

**Değişiklik:**
- `BASE_URL` artık boş başlıyor (hardcoded değer yok)
- `VITE_BASE_URL` environment variable'ı kullanılmıyor
- BASE_URL mutlaka `inbox-settings.json` dosyasından gelecek

### 2. JSON Dosyası Yükleme Düzeltildi

**Değişiklik:**
- Önce `/inbox-settings.json` deneniyor
- Bulunamazsa `/public/inbox-settings.json` deneniyor
- Vite dev server'da `public/` klasöründeki dosyalar root'tan erişilebilir

### 3. Vite Config Güncellendi

**Değişiklik:**
- JSON dosyaları için özel kontrol eklendi
- SPA routing JSON dosyalarını yakalamıyor

## 🚀 Test Et

### 1. Dev Server'ı Yeniden Başlat

```bash
# Dev server'ı durdurun (Ctrl+C)
# Sonra tekrar başlatın
cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"
npm run dev
```

### 2. Browser Console Kontrolü

F12 > Console'u açın:

**Başarılı:**
```
📋 JSON dosyası okundu, inbox: test232 bulundu: true
🔧 Chatwoot Base URL güncelleniyor: https://app.blxchat.lol
🌐 Chatwoot Base URL güncellendi: https://app.blxchat.lol
🌐 API çağrısı: POST https://app.blxchat.lol/public/api/v1/...
```

**Hata (Eski):**
```
⚠️ Ayarlar yüklenemedi, görsel inbox ID kullanılıyor
🌐 API çağrısı: POST https://call.betlabx.com/public/api/v1/...
```

### 3. Network Sekmesi Kontrolü

F12 > Network:
- `/inbox-settings.json` veya `/public/inbox-settings.json` isteği başarılı olmalı
- Status: `200 OK`
- Response: JSON formatında olmalı (HTML değil)

## 🔍 Sorun Giderme

### "Hala call.betlabx.com görünüyor"

1. **Dev server'ı yeniden başlatın:**
   ```bash
   # Ctrl+C ile durdurun
   npm run dev
   ```

2. **Browser cache'ini temizleyin:**
   - Ctrl+Shift+Delete
   - Cache'i temizle
   - Sayfayı yenile (Ctrl+F5)

3. **Console'da kontrol edin:**
   - `📋 JSON dosyası okundu` mesajı görünüyor mu?
   - `🌐 Chatwoot Base URL güncellendi` mesajı görünüyor mu?

### "JSON dosyası hala yüklenemiyor"

1. **Dosya var mı kontrol edin:**
   ```bash
   # Windows PowerShell
   Test-Path "public\inbox-settings.json"
   ```

2. **Vite dev server'da erişilebilir mi kontrol edin:**
   - Tarayıcıda: `http://localhost:5173/inbox-settings.json`
   - Veya: `http://localhost:5173/public/inbox-settings.json`
   - JSON formatında görünmeli (HTML değil)

3. **Vite config'i kontrol edin:**
   - `vite.config.js` dosyasında JSON dosyaları için özel kontrol var mı?

### "BASE_URL hala boş"

1. **JSON dosyasında chatwootBaseUrl var mı?**
   ```json
   {
     "test232": {
       "chatwootBaseUrl": "https://app.blxchat.lol"
     }
   }
   ```

2. **Console'da kontrol edin:**
   - `🔧 Chatwoot Base URL güncelleniyor` mesajı görünüyor mu?
   - `❌ Settings'te chatwootBaseUrl yok!` hatası var mı?

## ✅ Başarılı Çözüm

Eğer her şey doğru yapıldıysa:

1. ✅ JSON dosyası yüklendi
2. ✅ `chatwootBaseUrl` okundu
3. ✅ `BASE_URL` güncellendi: `https://app.blxchat.lol`
4. ✅ API çağrıları `app.blxchat.lol` üzerinden
5. ✅ `call.betlabx.com` hiçbir yerde görünmüyor

## 📋 Kontrol Listesi

- [ ] Dev server yeniden başlatıldı
- [ ] Browser cache temizlendi
- [ ] JSON dosyası yüklendi (`📋 JSON dosyası okundu`)
- [ ] BASE_URL güncellendi (`🌐 Chatwoot Base URL güncellendi`)
- [ ] API çağrıları `app.blxchat.lol` üzerinden
- [ ] `call.betlabx.com` görünmüyor

## 🔗 İlgili Dosyalar

- `src/api/blxchat.js` - BASE_URL tanımı (güncellenmiş)
- `src/App.jsx` - JSON dosyası yükleme (güncellenmiş)
- `vite.config.js` - SPA routing (güncellenmiş)
- `public/inbox-settings.json` - Chatwoot Base URL burada

