# Mixed Content Hatası Çözümü

## 🔴 Sorun

Sayfa `https://api.blxchat.lol/test232` üzerinden yükleniyor, ancak Chatwoot API `http://app.blxchat.lol` üzerinden çağrılıyor. Tarayıcılar HTTPS sayfalardan HTTP kaynaklara istek atmaya izin vermiyor (Mixed Content Policy).

**Hata:**
```
Mixed Content: The page at 'https://api.blxchat.lol/test232' was loaded over HTTPS, 
but requested an insecure resource 'http://app.blxchat.lol/public/api/v1/inboxes/...'. 
This request has been blocked; the content must be served over HTTPS.
```

## ✅ Çözüm 1: Admin Panelinden HTTPS Güncelleme (Önerilen)

**Adım 1:** Admin paneline giriş yapın: `https://api.blxchat.lol/admin`

**Adım 2:** `test232` inbox'unu düzenleyin

**Adım 3:** "Chatwoot API Base URL" alanını güncelleyin:
- **Eski:** `http://app.blxchat.lol`
- **Yeni:** `https://app.blxchat.lol`

**Adım 4:** Kaydedin

**ÖNEMLİ:** `app.blxchat.lol` domain'inin HTTPS desteklediğinden emin olun! Eğer desteklemiyorsa, Nginx Proxy Manager veya benzeri bir reverse proxy kullanarak HTTPS sertifikası ekleyin.

## ✅ Çözüm 2: Otomatik HTTPS Dönüşümü (Kod Güncellemesi)

Kodda otomatik HTTPS dönüşümü eklendi. Eğer sayfa HTTPS üzerinden yükleniyorsa ve `chatwootBaseUrl` HTTP ise, otomatik olarak HTTPS'e çevrilecek.

**Ancak:** Bu çözüm sadece `app.blxchat.lol` HTTPS destekliyorsa çalışır. Eğer desteklemiyorsa, API çağrıları yine başarısız olacaktır.

## 🔍 Kontrol

1. **Chatwoot HTTPS Kontrolü:**
   ```bash
   curl -I https://app.blxchat.lol
   ```
   
   Eğer `200 OK` dönerse, HTTPS destekleniyor demektir.

2. **Browser Console:**
   - F12 > Console
   - `🔒 Mixed Content koruması: HTTP -> HTTPS dönüştürüldü:` mesajını kontrol edin
   - `🌐 Chatwoot Base URL güncellendi: https://app.blxchat.lol` mesajını kontrol edin

## 🚨 Service Worker ve Icon Hataları

### Service Worker 404 Hatası

**Sorun:** `service-worker.js` dosyası bulunamıyor.

**Çözüm:** `.htaccess` dosyasına Service Worker dosyaları için özel kural eklendi. Service Worker dosyaları `public/` klasöründe olmalı ve root'tan erişilebilir olmalı.

**Kontrol:**
- `public/service-worker.js` dosyası var mı?
- `public/firebase-messaging-sw.js` dosyası var mı?
- `.htaccess` dosyası güncel mi?

### Icon 404 Hatası

**Sorun:** `icon-192.png` ve `icon-512.png` dosyaları bulunamıyor.

**Çözüm 1:** Icon dosyalarını oluşturun ve root'a ekleyin:
- `icon-192.png` (192x192 px)
- `icon-512.png` (512x512 px)

**Çözüm 2:** Manifest.json'dan icon referanslarını kaldırın veya mevcut logo URL'lerini kullanın.

## 📋 Sunucuya Yüklenecek Dosyalar (Güncellenmiş)

1. ✅ `dist/` klasörü (build edilmiş frontend)
2. ✅ `public/` klasörü (Service Worker, API, JSON dosyaları)
3. ✅ `admin/` klasörü (güncellenmiş admin panel)
4. ✅ `.htaccess` dosyası (Service Worker kuralları ile güncellenmiş)
5. ✅ `icon-192.png` ve `icon-512.png` (eğer varsa)

## 🔧 Nginx Proxy Manager Ayarları

Eğer `app.blxchat.lol` için HTTPS yapılandırması yapmanız gerekiyorsa:

1. **Nginx Proxy Manager'a giriş yapın**
2. **Proxy Host ekleyin:**
   - Domain Names: `app.blxchat.lol`
   - Scheme: `http`
   - Forward Hostname/IP: Chatwoot sunucu IP'si
   - Forward Port: Chatwoot port (genellikle 3000)
3. **SSL Certificate ekleyin:**
   - Let's Encrypt kullanarak otomatik sertifika alın
   - Veya mevcut sertifikanızı yükleyin

## ✅ Başarılı Yükleme Kontrolü

1. ✅ Sayfa açılıyor: `https://api.blxchat.lol/test232`
2. ✅ Mixed Content hatası yok
3. ✅ Service Worker kayıtlı
4. ✅ Icon dosyaları yükleniyor
5. ✅ Mesajlar Chatwoot'a gidiyor
6. ✅ API çağrıları başarılı

## 🆘 Sorun Giderme

### "Mixed Content hatası devam ediyor"

1. **Admin panelinden `chatwootBaseUrl`'yi kontrol edin:**
   - `https://app.blxchat.lol` olmalı (HTTP değil)

2. **Browser cache'ini temizleyin:**
   - Ctrl+Shift+Delete
   - Cache'i temizle
   - Sayfayı yenileyin (Ctrl+F5)

3. **Console'da BASE_URL'i kontrol edin:**
   - F12 > Console
   - `🌐 Chatwoot Base URL güncellendi:` mesajını kontrol edin
   - HTTPS olmalı

### "Service Worker kayıt hatası"

1. **Service Worker dosyasının varlığını kontrol edin:**
   - `https://api.blxchat.lol/service-worker.js` açılmalı
   - `https://api.blxchat.lol/firebase-messaging-sw.js` açılmalı

2. **.htaccess dosyasını kontrol edin:**
   - Service Worker kuralları eklenmiş mi?

3. **Apache mod_rewrite aktif mi?**
   ```bash
   sudo a2enmod rewrite
   sudo systemctl restart apache2
   ```

### "Icon dosyaları bulunamıyor"

1. **Icon dosyalarını oluşturun:**
   - 192x192 px PNG
   - 512x512 px PNG

2. **Root'a yükleyin:**
   - `/var/www/html/icon-192.png`
   - `/var/www/html/icon-512.png`

3. **Veya manifest.json'dan kaldırın:**
   - `manifest.json` dosyasını düzenleyin
   - Icon referanslarını kaldırın veya mevcut logo URL'lerini kullanın

## 📞 Destek

Sorun devam ederse:
1. Browser Console loglarını kontrol edin
2. Network sekmesinde API çağrılarını kontrol edin
3. Server loglarını kontrol edin (Apache error log)

