# 📱 Mobil Bildirim Rehberi (Android & iOS)

## 🔔 Bildirim Sistemi

BLXChat uygulaması Android ve iOS platformlarında bildirim desteği sunar.

## 📋 Platform Özellikleri

### Android

- ✅ **Bildirimler desteklenir** (Chrome, Edge, Samsung Internet)
- ✅ **Sayfa görünürken de bildirim gönderilir** (uygulama açık olsa bile)
- ✅ **Service Worker gereklidir** (otomatik kayıt edilir)
- ✅ **Vibrate desteği** (bildirim geldiğinde titreşim)
- ✅ **Action butonları** (Aç/Kapat)

### iOS

- ✅ **Bildirimler desteklenir** (Safari 16.4+, iOS 16.4+)
- ⚠️ **PWA modu gereklidir** (ana ekrana eklenmiş olmalı)
- ✅ **Service Worker gereklidir** (otomatik kayıt edilir)
- ❌ **Vibrate desteği yok** (iOS'ta vibrate API'si yok)
- ❌ **Action butonları sınırlı** (iOS'ta actions desteği yok)

## 🚀 Kurulum Adımları

### Android

1. **Tarayıcıda aç:**
   - Chrome, Edge veya Samsung Internet kullanın
   - Uygulamayı açın: `https://api.blxchat.lol/test1234`

2. **Bildirim izni ver:**
   - Uygulama açıldığında bildirim izni istenir
   - "İzin Ver" butonuna tıklayın
   - Test bildirimi gönderilir

3. **PWA olarak yükle (opsiyonel):**
   - Chrome menüsünden "Ana ekrana ekle" seçeneğini seçin
   - Uygulama ana ekrana eklenecek

### iOS

1. **Safari'de aç:**
   - Safari tarayıcısını kullanın (iOS 16.4+)
   - Uygulamayı açın: `https://api.blxchat.lol/test1234`

2. **Ana ekrana ekle (PWA modu):**
   - Safari'de paylaş butonuna (⬆️) basın
   - "Ana Ekrana Ekle" seçeneğini seçin
   - Uygulamayı ana ekrandan açın

3. **Bildirim izni ver:**
   - PWA modunda açıldığında bildirim izni istenir
   - "İzin Ver" butonuna tıklayın
   - Test bildirimi gönderilir

## 🧪 Test

### Test Bildirimi Gönderme

1. **Console'dan test:**
   ```javascript
   // Tarayıcı console'unda (F12)
   testNotification();
   ```

2. **Manuel test:**
   - Admin panelinden test mesajı gönderin
   - Mobil cihazda yeni mesaj geldiğinde bildirim görmelisiniz

### Bildirim Durumunu Kontrol Etme

Console'da şu log'ları göreceksiniz:

```
📱 Platform: { isMobile: true, isIOS: true, isAndroid: false, isStandalone: true, isHidden: false, permission: 'granted' }
🔔 Bildirim gönderiliyor: Temsilci - Mesaj içeriği...
✅ Service Worker hazır, bildirim gönderiliyor...
✅ Bildirim başarıyla gönderildi (Service Worker)
```

## 🐛 Sorun Giderme

### Sorun: "Bildirim izni verilmemiş"

**Çözüm:**
1. Tarayıcı ayarlarından bildirim iznini kontrol edin
2. Android: Ayarlar → Uygulamalar → Chrome → Bildirimler → İzin ver
3. iOS: Ayarlar → Safari → Bildirimler → İzin ver

### Sorun: "iOS'ta bildirim gelmiyor"

**Çözüm:**
1. Uygulamanın PWA modunda açıldığından emin olun (ana ekrandan)
2. Safari'de değil, ana ekrandaki uygulamadan açın
3. Bildirim izninin verildiğini kontrol edin
4. iOS 16.4+ kullandığınızdan emin olun

### Sorun: "Android'de bildirim gelmiyor"

**Çözüm:**
1. Service Worker'ın kayıtlı olduğunu kontrol edin (Console'da log'ları kontrol edin)
2. Bildirim izninin verildiğini kontrol edin
3. Chrome/Edge güncel versiyonunu kullanın
4. HTTPS bağlantısı kullanın (HTTP'de bildirimler çalışmaz)

### Sorun: "Service Worker kayıtlı değil"

**Çözüm:**
1. HTTPS bağlantısı kullanın
2. Tarayıcı cache'ini temizleyin
3. Service Worker'ı manuel olarak kaydedin:
   ```javascript
   navigator.serviceWorker.register('/service-worker.js')
     .then(reg => console.log('✅ Kayıtlı:', reg))
     .catch(err => console.error('❌ Hata:', err));
   ```

## 📝 Önemli Notlar

1. **HTTPS Gereklidir:** Bildirimler sadece HTTPS bağlantısında çalışır
2. **Service Worker Gereklidir:** Service Worker kayıtlı olmalı
3. **iOS PWA Modu:** iOS'ta bildirimler sadece PWA modunda çalışır
4. **Android Her Zaman:** Android'de sayfa görünürken de bildirim gönderilir
5. **Tarayıcı Desteği:** 
   - Android: Chrome, Edge, Samsung Internet
   - iOS: Safari 16.4+ (iOS 16.4+)

## 🔍 Debug Komutları

### Console'da Test

```javascript
// Bildirim izni durumunu kontrol et
Notification.permission

// Service Worker durumunu kontrol et
navigator.serviceWorker.getRegistrations().then(regs => console.log(regs))

// Test bildirimi gönder
testNotification()

// Platform bilgilerini kontrol et
console.log({
  isMobile: /Android|iPhone|iPad/i.test(navigator.userAgent),
  isIOS: /iPhone|iPad|iPod/i.test(navigator.userAgent),
  isAndroid: /Android/i.test(navigator.userAgent),
  isStandalone: window.matchMedia('(display-mode: standalone)').matches || window.navigator.standalone,
  permission: Notification.permission
})
```

## ✅ Kontrol Listesi

- [ ] HTTPS bağlantısı kullanılıyor
- [ ] Service Worker kayıtlı
- [ ] Bildirim izni verildi
- [ ] Android: Herhangi bir tarayıcıda çalışır
- [ ] iOS: PWA modunda açıldı (ana ekrandan)
- [ ] Test bildirimi gönderildi
- [ ] Yeni mesaj geldiğinde bildirim alınıyor

## 🎯 Özet

- **Android:** Her zaman bildirim gönderilir (sayfa görünürken de)
- **iOS:** Sadece PWA modunda bildirim gönderilir
- **Service Worker:** Her iki platformda da gereklidir
- **HTTPS:** Bildirimler için zorunludur

**Başarılar! 🎉**

