# 🔧 Nginx Proxy Manager Yapılandırma Rehberi

## ❌ YANLIŞ Yapılandırma

Şu anda domain'i `154.53.165.195:5173` portuna yönlendirmişsiniz. Bu **Vite dev server** portu ve production için uygun değil!

## ✅ DOĞRU Yapılandırma

### 1. Apache Portunu Bulun

SSH ile sunucuya bağlanın ve Apache'nin hangi portta çalıştığını kontrol edin:

```bash
# Apache durumunu kontrol et
sudo systemctl status apache2

# Apache portunu kontrol et
sudo netstat -tlnp | grep apache
# veya
sudo ss -tlnp | grep apache

# Genellikle 80 veya 8080 portunda çalışır
```

### 2. Apache'nin Çalıştığından Emin Olun

```bash
# Apache başlat (eğer çalışmıyorsa)
sudo systemctl start apache2
sudo systemctl enable apache2

# Apache durumunu kontrol et
sudo systemctl status apache2
```

### 3. Apache Virtual Host Kontrolü

Apache'nin doğru klasörü serve ettiğinden emin olun:

```bash
# Apache config dosyasını kontrol et
sudo nano /etc/apache2/sites-available/000-default.conf
# veya
sudo nano /etc/apache2/sites-available/blxchat.conf
```

**Örnek Virtual Host:**
```apache
<VirtualHost *:80>
    ServerName domain.com
    ServerAlias www.domain.com
    
    DocumentRoot /path/to/pwa-chatwoot
    
    <Directory /path/to/pwa-chatwoot>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
    
    ErrorLog ${APACHE_LOG_DIR}/blxchat-error.log
    CustomLog ${APACHE_LOG_DIR}/blxchat-access.log combined
</VirtualHost>
```

**Önemli:** `/path/to/pwa-chatwoot` kısmını gerçek klasör yolunuzla değiştirin!

### 4. Nginx Proxy Manager Ayarları

Nginx Proxy Manager'da yeni bir **Proxy Host** oluşturun veya mevcut olanı düzenleyin:

#### 4.1. Details Sekmesi

- **Domain Names:** `domain.com` (veya `www.domain.com`)
- **Scheme:** `http`
- **Forward Hostname/IP:** `154.53.165.195` (sunucu IP'niz)
- **Forward Port:** `80` (veya Apache'nin çalıştığı port, örn: `8080`)
- **Cache Assets:** ✅ (İsteğe bağlı)
- **Block Common Exploits:** ✅ (Önerilen)
- **Websockets Support:** ✅ (Chat için gerekli olabilir)

#### 4.2. SSL Sekmesi (Önerilen)

- **SSL Certificate:** Let's Encrypt ile otomatik SSL alın
- **Force SSL:** ✅ (HTTP'yi HTTPS'e yönlendir)
- **HTTP/2 Support:** ✅

#### 4.3. Advanced Sekmesi (Opsiyonel)

Eğer özel ayarlar gerekiyorsa:

```nginx
# Custom Nginx Configuration
location / {
    proxy_pass http://154.53.165.195:80;
    proxy_set_header Host $host;
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto $scheme;
    
    # WebSocket support (eğer gerekiyorsa)
    proxy_http_version 1.1;
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection "upgrade";
}
```

### 5. Vite Dev Server'ı Kapatın

Vite dev server çalışıyorsa kapatın (production için gerekli değil):

```bash
# Vite dev server'ı durdurun
# Ctrl+C ile veya process'i kill edin
ps aux | grep vite
kill <PID>
```

## 🔍 Kontrol Listesi

- [ ] Apache çalışıyor mu? (`sudo systemctl status apache2`)
- [ ] Apache hangi portta çalışıyor? (genellikle 80)
- [ ] Apache virtual host doğru klasörü gösteriyor mu?
- [ ] `.htaccess` dosyası root'ta mı?
- [ ] `dist/` klasörü var mı ve içinde dosyalar var mı?
- [ ] `public/` klasörü var mı?
- [ ] Nginx Proxy Manager'da doğru port ayarlı mı? (5173 değil, 80 veya 8080)
- [ ] Vite dev server kapatıldı mı?

## 🧪 Test

### 1. Apache'yi Doğrudan Test Edin

```bash
# Sunucuda test et
curl http://localhost/test232
# veya
curl http://154.53.165.195/test232
```

### 2. Nginx Proxy Manager Üzerinden Test Edin

Tarayıcıda:
- `http://domain.com/test232`
- `http://domain.com/admin/`
- `http://domain.com/inbox-settings.json`

## 🐛 Sorun Giderme

### Sorun: "502 Bad Gateway"

**Çözüm:**
1. Apache çalışıyor mu kontrol et: `sudo systemctl status apache2`
2. Apache portunu kontrol et: `sudo netstat -tlnp | grep apache`
3. Nginx Proxy Manager'da doğru port ayarlı mı kontrol et (80 veya 8080, 5173 değil!)

### Sorun: "404 Not Found"

**Çözüm:**
1. Apache virtual host doğru klasörü gösteriyor mu?
2. `.htaccess` dosyası var mı?
3. `dist/` klasörü var mı?
4. Apache `mod_rewrite` aktif mi? (`sudo a2enmod rewrite`)

### Sorun: "Internal Server Error"

**Çözüm:**
1. Apache error log kontrol et:
   ```bash
   sudo tail -f /var/log/apache2/error.log
   ```
2. `.htaccess` syntax hatası olabilir
3. Apache config'de `AllowOverride All` var mı?

### Sorun: JSON Dosyaları Yüklenmiyor

**Çözüm:**
1. `public/inbox-settings.json` var mı?
2. `.htaccess` JSON rewrite kuralları doğru mu?
3. Tarayıcı console'da network sekmesini kontrol et

## 📝 Özet

1. **Apache portunu bul** (genellikle 80)
2. **Apache'nin çalıştığından emin ol**
3. **Nginx Proxy Manager'da domain'i Apache portuna yönlendir** (5173 değil!)
4. **Vite dev server'ı kapat**
5. **Test et**

**Önemli:** Nginx Proxy Manager'da **Forward Port** değeri **5173 değil, 80** (veya Apache'nin çalıştığı port) olmalı!

## 🚀 Hızlı Komutlar

```bash
# Apache durumunu kontrol et
sudo systemctl status apache2

# Apache portunu bul
sudo netstat -tlnp | grep apache

# Apache'yi başlat
sudo systemctl start apache2

# Apache'yi yeniden başlat
sudo systemctl restart apache2

# Apache error log'u izle
sudo tail -f /var/log/apache2/error.log

# Apache access log'u izle
sudo tail -f /var/log/apache2/access.log
```

**Başarılar! 🎉**

