# Portainer ile BLXChat Kurulumu

Bu dokümantasyon, BLXChat uygulamasını Portainer kullanarak Docker container olarak çalıştırmak için adım adım talimatlar içerir.

## 📋 Gereksinimler

- Portainer kurulu ve çalışıyor olmalı
- Docker ve Docker Compose erişimi
- En az 512MB RAM ve 1GB disk alanı

## 🚀 Kurulum Adımları

### Yöntem 1: Portainer UI ile (Önerilen)

#### 1. Projeyi Portainer'a Yükleme

1. Portainer'a giriş yapın
2. **Stacks** menüsüne gidin
3. **Add stack** butonuna tıklayın
4. Stack adı: `blxchat`
5. **Web editor** sekmesine geçin
6. `docker-compose.yml` dosyasının içeriğini yapıştırın:

```yaml
version: '3.8'

services:
  blxchat:
    build:
      context: .
      dockerfile: Dockerfile
    image: blxchat:latest
    container_name: blxchat
    restart: unless-stopped
    ports:
      - "8080:80"
    volumes:
      - ./public/inbox-settings.json:/var/www/html/public/inbox-settings.json
      - ./public/users.json:/var/www/html/public/users.json
      - ./public/companies.json:/var/www/html/public/companies.json
      - ./public/admin-config.json:/var/www/html/public/admin-config.json
      - ./public/logos:/var/www/html/public/logos
      - ./public/chatwoot-api-debug.log:/var/www/html/public/chatwoot-api-debug.log
    environment:
      - NODE_ENV=production
    networks:
      - blxchat-network

networks:
  blxchat-network:
    driver: bridge
```

7. **Deploy the stack** butonuna tıklayın

#### 2. Build Context Ayarlama

Eğer build context hatası alırsanız:

1. **Stacks** > `blxchat` > **Editor**
2. Build context'i ayarlayın:
   - **Build method**: Git repository veya Upload files
   - Proje dosyalarını yükleyin

### Yöntem 2: Git Repository ile

1. Portainer'da **Stacks** > **Add stack**
2. Stack adı: `blxchat`
3. **Repository** sekmesine geçin
4. Repository URL'ini girin (GitHub, GitLab, vb.)
5. **Compose path**: `docker-compose.yml`
6. **Deploy the stack** butonuna tıklayın

### Yöntem 3: Manuel Build (SSH/Terminal)

Eğer Portainer'da build yapamıyorsanız, önce image'ı build edin:

```bash
# Proje dizinine gidin
cd /path/to/pwa-chatwoot

# Image'ı build edin
docker build -t blxchat:latest .

# Portainer'da sadece image'ı kullanın
```

Sonra Portainer'da:
1. **Stacks** > **Add stack**
2. `docker-compose.yml` içinde `build:` yerine `image: blxchat:latest` kullanın

## ⚙️ Yapılandırma

### Port Ayarları

Varsayılan port: `8080`

Port değiştirmek için `docker-compose.yml` içinde:
```yaml
ports:
  - "YENI_PORT:80"  # Örn: "3000:80"
```

### Volume Mounts

JSON dosyaları ve logos kalıcı olarak saklanır:
- `inbox-settings.json` - Inbox ayarları
- `users.json` - Kullanıcı hesapları
- `companies.json` - Firma kategorileri
- `admin-config.json` - API ayarları
- `logos/` - Yüklenen logo dosyaları

### Environment Variables

Gerekirse environment variables ekleyebilirsiniz:
```yaml
environment:
  - NODE_ENV=production
  - PHP_MEMORY_LIMIT=256M
```

## 🔍 Kontrol ve Test

### Container Durumu

1. Portainer'da **Containers** menüsüne gidin
2. `blxchat` container'ını bulun
3. Durum: **Running** olmalı

### Logları Kontrol Etme

1. Container'a tıklayın
2. **Logs** sekmesine gidin
3. Apache başlangıç loglarını kontrol edin

### Uygulamaya Erişim

- **Chat Uygulaması**: `http://SUNUCU_IP:8080/`
- **Admin Panel**: `http://SUNUCU_IP:8080/admin/`
- **Test Inbox**: `http://SUNUCU_IP:8080/test` (eğer test inbox'u varsa)

## 🔧 Sorun Giderme

### Container Başlamıyor

1. **Logs** sekmesini kontrol edin
2. Build hatası varsa:
   - Dockerfile'ı kontrol edin
   - Build context'i doğru ayarlayın
   - Disk alanını kontrol edin

### Port Çakışması

Eğer 8080 portu kullanılıyorsa:
```yaml
ports:
  - "8081:80"  # Farklı port kullanın
```

### Permission Hatası

JSON dosyalarına yazma izni yoksa:
```bash
# Host'ta dosya izinlerini ayarlayın
chmod 666 public/*.json
chmod 777 public/logos
```

### PHP Hataları

1. Container'a girin:
   ```bash
   docker exec -it blxchat bash
   ```
2. PHP loglarını kontrol edin:
   ```bash
   tail -f /var/log/apache2/error.log
   ```

## 📦 Güncelleme

### Yeni Versiyon Yükleme

1. **Stacks** > `blxchat` > **Editor**
2. `docker-compose.yml` dosyasını güncelleyin
3. **Update the stack** butonuna tıklayın
4. Veya **Recreate** butonunu kullanın

### Veri Yedekleme

Önemli: Volume mount'lar sayesinde veriler korunur, ama yine de yedek alın:

```bash
# JSON dosyalarını yedekle
cp public/*.json backup/
cp -r public/logos backup/logos/
```

## 🌐 Reverse Proxy (Nginx/Traefik)

Eğer domain kullanmak istiyorsanız:

### Nginx Reverse Proxy Örneği

```nginx
server {
    listen 80;
    server_name chat.example.com;

    location / {
        proxy_pass http://localhost:8080;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
    }
}
```

### Traefik Labels (docker-compose.yml içinde)

```yaml
labels:
  - "traefik.enable=true"
  - "traefik.http.routers.blxchat.rule=Host(`chat.example.com`)"
  - "traefik.http.routers.blxchat.entrypoints=web"
  - "traefik.http.services.blxchat.loadbalancer.server.port=80"
```

## 📝 Notlar

- İlk kurulumda admin şifresi: `admin123` (değiştirin!)
- JSON dosyaları container dışında saklanır (volume mount)
- Logos klasörü kalıcıdır
- Health check her 30 saniyede bir çalışır

## 🆘 Destek

Sorun yaşarsanız:
1. Container loglarını kontrol edin
2. Portainer event loglarını inceleyin
3. Disk alanı ve RAM kullanımını kontrol edin

