# 🚀 Portainer'da Stack Oluşturma - Adım Adım

## 📍 Dosyalar Yüklendi, Şimdi Ne Yapacağız?

### 1️⃣ Klasör Yolunu Bulma

Önce dosyaları nereye yüklediğinizi bilmeniz gerekiyor:

**WinSCP'de yüklediyseniz:**
- Sağ panelde (sunucu tarafı) hangi klasöre yüklediğinizi kontrol edin
- Genellikle: `/root/blxchat` veya `/home/user/blxchat` veya `/opt/blxchat`

**SSH ile kontrol edin:**
```bash
# SSH ile sunucuya bağlanın
ssh user@SUNUCU_IP

# Dosyaların olduğu yeri bulun
ls -la /root/blxchat
# veya
ls -la /home/user/blxchat
```

**ÖNEMLİ:** Klasör yolunu not edin! (Örnek: `/root/blxchat`)

---

## 2️⃣ Portainer'da Stack Oluşturma

### Adım 1: Portainer'a Giriş

1. Portainer web arayüzüne giriş yapın
2. Sol menüden **Stacks** seçeneğine tıklayın
3. **Add stack** butonuna tıklayın

### Adım 2: Stack Bilgileri

1. **Name**: `blxchat` yazın (veya istediğiniz isim)
2. **Build method**: **Web editor** seçin

### Adım 3: Docker Compose Kodu

Aşağıdaki kodu kopyalayıp **Web editor** alanına yapıştırın:

```yaml
version: '3.8'

services:
  blxchat:
    build:
      context: /root/blxchat
      dockerfile: Dockerfile
    image: blxchat:latest
    container_name: blxchat
    restart: unless-stopped
    ports:
      - "8080:80"
    volumes:
      - /root/blxchat/public:/var/www/html/public
    environment:
      - NODE_ENV=production
    networks:
      - blxchat-network
    healthcheck:
      test: ["CMD-SHELL", "curl -f http://localhost/ || exit 1"]
      interval: 30s
      timeout: 10s
      retries: 3
      start_period: 40s

networks:
  blxchat-network:
    driver: bridge
```

### Adım 4: Klasör Yolunu Düzeltme

**⚠️ ÖNEMLİ:** `context: /root/blxchat` kısmını, dosyaları yüklediğiniz gerçek yolla değiştirin!

**Örnekler:**
- Eğer `/home/user/blxchat`'e yüklediyseniz:
  ```yaml
  context: /home/user/blxchat
  volumes:
    - /home/user/blxchat/public:/var/www/html/public
  ```

- Eğer `/opt/blxchat`'e yüklediyseniz:
  ```yaml
  context: /opt/blxchat
  volumes:
    - /opt/blxchat/public:/var/www/html/public
  ```

### Adım 5: Deploy

1. **Deploy the stack** butonuna tıklayın
2. Build işlemi başlayacak (5-10 dakika sürebilir)
3. İlerlemeyi **Logs** sekmesinden takip edebilirsiniz

---

## 3️⃣ Kontrol ve Test

### Container Durumunu Kontrol Etme

1. **Stacks** > `blxchat` > **Containers** sekmesine gidin
2. Container durumu **Running** olmalı
3. Eğer **Stopped** ise, **Logs** sekmesini kontrol edin

### Logları İnceleme

1. Container'a tıklayın
2. **Logs** sekmesine gidin
3. Hata mesajı var mı kontrol edin

### Uygulamayı Test Etme

1. Tarayıcıda açın: `http://SUNUCU_IP:8080/admin/`
2. Varsayılan şifre: `admin123`
3. Giriş yapabildiyseniz başarılı! ✅

---

## 🔧 Yaygın Sorunlar ve Çözümleri

### Sorun 1: "Cannot find Dockerfile"

**Çözüm:**
- `context:` yolunu kontrol edin
- Dockerfile'ın o klasörde olduğundan emin olun
- SSH ile kontrol edin:
  ```bash
  ls -la /root/blxchat/Dockerfile
  ```

### Sorun 2: "Build context not found"

**Çözüm:**
- Klasör yolunu doğru yazdığınızdan emin olun
- Absolute path kullanın (başında `/` olmalı)
- Portainer'ın erişim izni olduğundan emin olun

### Sorun 3: "Permission denied"

**Çözüm:**
SSH ile sunucuya bağlanın ve izinleri düzeltin:
```bash
chmod -R 755 /root/blxchat
chown -R root:root /root/blxchat
```

### Sorun 4: Port Çakışması

**Çözüm:**
Eğer 8080 portu kullanılıyorsa, farklı bir port kullanın:
```yaml
ports:
  - "3000:80"  # 3000 portunu kullan
```

---

## 📋 Kontrol Listesi

- [ ] Dosyalar sunucuya yüklendi
- [ ] Klasör yolu belirlendi (örn: `/root/blxchat`)
- [ ] Portainer'da stack oluşturuldu
- [ ] `context:` yolu doğru ayarlandı
- [ ] `volumes:` yolu doğru ayarlandı
- [ ] Stack deploy edildi
- [ ] Container **Running** durumunda
- [ ] Admin paneli açılıyor (`http://SUNUCU_IP:8080/admin/`)

---

## 🎯 Hızlı Komutlar (SSH ile)

Sunucuya SSH ile bağlanıp kontrol edebilirsiniz:

```bash
# Dosyaların olduğu yeri bul
find / -name "Dockerfile" -type f 2>/dev/null | grep blxchat

# Klasör içeriğini kontrol et
ls -la /root/blxchat/

# Dockerfile var mı?
ls -la /root/blxchat/Dockerfile

# İzinleri düzelt (gerekirse)
chmod -R 755 /root/blxchat
```

---

## ✅ Başarılı Kurulum Sonrası

1. **Admin şifresini değiştirin!**
2. **API ayarlarını yapın** (opsiyonel)
3. **İlk inbox'u oluşturun**
4. **Chat uygulamasını test edin**

**Başarılar! 🎉**

