# 🚀 Production Kurulum Rehberi

## ❌ Şu Anki Durum

PM2 ile Vite dev server çalışıyor (port 5173). Bu **development** modu, **production** için uygun değil!

## ✅ Production İçin Yapılacaklar

### 1. Vite Dev Server'ı Durdur

```bash
# PM2 process'ini durdur
pm2 stop blxchat-dev
pm2 delete blxchat-dev

# Veya tüm PM2 process'lerini kontrol et
pm2 list
pm2 stop all
```

### 2. Production Build Yap

```bash
# Proje klasörüne git
cd /srv/blxchat
# veya
cd /path/to/pwa-chatwoot

# Build yap
npm run build
```

**Kontrol:**
```bash
# dist/ klasörü oluştu mu?
ls -la dist/

# dist/index.html var mı?
ls -la dist/index.html

# dist/assets/ klasörü var mı?
ls -la dist/assets/
```

### 3. Apache'nin Çalıştığından Emin Ol

```bash
# Apache durumunu kontrol et
sudo systemctl status apache2

# Eğer çalışmıyorsa başlat
sudo systemctl start apache2
sudo systemctl enable apache2
```

### 4. Apache Virtual Host Kontrolü

Apache'nin doğru klasörü serve ettiğinden emin ol:

```bash
# Virtual host dosyasını kontrol et
sudo nano /etc/apache2/sites-available/000-default.conf
```

**Doğru yapılandırma:**
```apache
<VirtualHost *:80>
    DocumentRoot /srv/blxchat
    # veya
    # DocumentRoot /path/to/pwa-chatwoot
    
    <Directory /srv/blxchat>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

### 5. Apache'yi Restart Et

```bash
sudo systemctl restart apache2
```

### 6. Nginx Proxy Manager Ayarları

Nginx Proxy Manager'da:
- **Forward Port:** `80` (5173 değil!)
- **Forward Hostname/IP:** `154.53.165.195`

### 7. Test Et

```bash
# Sunucuda test
curl http://localhost/test232

# Domain üzerinden test
# http://domain.com/test232
```

## 📋 Kontrol Listesi

- [ ] Vite dev server durduruldu (`pm2 stop blxchat-dev`)
- [ ] Production build yapıldı (`npm run build`)
- [ ] `dist/` klasörü mevcut ve içinde dosyalar var
- [ ] Apache çalışıyor (`sudo systemctl status apache2`)
- [ ] Apache virtual host doğru klasörü gösteriyor
- [ ] `.htaccess` dosyası güncel
- [ ] Nginx Proxy Manager'da Forward Port = `80`
- [ ] Domain üzerinden test edildi

## 🔄 Development vs Production

| Özellik | Development | Production |
|---------|-------------|------------|
| Server | Vite dev server | Apache |
| Port | 5173 | 80 |
| Build | Gerekmez | `npm run build` |
| Dosyalar | `src/` | `dist/` |
| Hız | Yavaş (dev mode) | Hızlı (optimize) |

## 🐛 Sorun Giderme

### Sorun: "502 Bad Gateway"

**Çözüm:**
```bash
# Apache çalışıyor mu?
sudo systemctl status apache2

# Apache portunu kontrol et
sudo netstat -tlnp | grep apache

# Nginx Proxy Manager'da port 80 mi? (5173 değil!)
```

### Sorun: "404 Not Found"

**Çözüm:**
```bash
# dist/ klasörü var mı?
ls -la dist/

# .htaccess var mı?
ls -la .htaccess

# Apache mod_rewrite aktif mi?
sudo a2enmod rewrite
sudo systemctl restart apache2
```

### Sorun: Beyaz Ekran

**Çözüm:**
1. Tarayıcı cache'ini temizle (Ctrl+Shift+R)
2. Console'u kontrol et (F12 → Console)
3. Network sekmesini kontrol et (F12 → Network)
4. Apache error log'unu kontrol et:
   ```bash
   sudo tail -f /var/log/apache2/error.log
   ```

## 🚀 Hızlı Komutlar

```bash
# Vite dev server'ı durdur
pm2 stop blxchat-dev
pm2 delete blxchat-dev

# Build yap
npm run build

# Apache'yi restart et
sudo systemctl restart apache2

# Apache durumunu kontrol et
sudo systemctl status apache2

# Apache portunu kontrol et
sudo netstat -tlnp | grep apache

# Apache error log'unu izle
sudo tail -f /var/log/apache2/error.log
```

## 📝 Özet

1. **Vite dev server'ı durdur** (`pm2 stop blxchat-dev`)
2. **Build yap** (`npm run build`)
3. **Apache'yi kontrol et** (`sudo systemctl status apache2`)
4. **Nginx Proxy Manager'da portu 80 yap** (5173 değil!)
5. **Test et** (`http://domain.com/test232`)

**Önemli:** Production için Vite dev server **kullanılmamalı**! Apache kullanılmalı.

**Başarılar! 🎉**

