# 🚀 Hızlı Başlangıç - Debian Sunucu

## Adım 1: Sunucuya Bağlan

```bash
ssh kullanici@sunucu-ip
cd /path/to/pwa-chatwoot  # SFTP ile yüklediğiniz klasör
```

## Adım 2: Script'i Çalıştır

```bash
chmod +x deploy-manual.sh
./deploy-manual.sh
```

**Script otomatik olarak:**
- ✅ Node.js yoksa kurar
- ✅ npm install yapar
- ✅ Production build alır
- ✅ Nasıl çalıştıracağınızı gösterir

## Adım 3: Uygulamayı Çalıştır

### Basit Yöntem (Direkt):
```bash
npm start
```
➡️ `http://sunucu-ip:8080` adresinden erişin

### Arka Planda Çalıştırma (PM2 ile):
```bash
# PM2 kur (ilk seferde)
sudo npm install -g pm2

# Uygulamayı başlat
pm2 start server-static.js --name betlabx-chat

# Sistem açılışta otomatik başlat
pm2 startup
pm2 save
```

---

## Manuel Kurulum (Script çalışmazsa)

### 1. Node.js Kurulumu:
```bash
curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
sudo apt-get update
sudo apt-get install -y nodejs
```

### 2. Kontrol:
```bash
node --version  # v20.x.x
npm --version   # 10.x.x
```

### 3. Build ve Çalıştır:
```bash
npm install
npm run build
npm start
```

---

## 🔧 Sorun Giderme

### "npm: command not found" hatası:
```bash
# Node.js kurulumunu tekrar yap
curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
sudo apt-get install -y nodejs
```

### "Permission denied" hatası:
```bash
# Sudo ile çalıştır
sudo npm install -g pm2
```

### Port zaten kullanılıyor:
```bash
# Farklı port kullan
PORT=3000 npm start
```

---

**Tüm hazır! 🎉**

