# 🚀 Apache Setup Script Kullanım Rehberi

## 📋 Script Ne Yapar?

`setup-apache.sh` scripti otomatik olarak:

1. ✅ Apache kurulumunu kontrol eder (yoksa kurar)
2. ✅ `mod_rewrite` modülünü aktif eder
3. ✅ Apache portunu bulur
4. ✅ Virtual host yapılandırmasını kontrol eder ve düzenler
5. ✅ Dosya yapısını kontrol eder (`.htaccess`, `dist/`, `public/`)
6. ✅ Dosya izinlerini düzenler
7. ✅ Apache yapılandırmasını test eder
8. ✅ Apache'yi başlatır/restart eder
9. ✅ Test isteği gönderir

## 🚀 Kullanım

### 1. Script'i Sunucuya Yükle

WinSCP veya SFTP ile `setup-apache.sh` dosyasını sunucuya yükleyin:
- Lokal: `C:\Users\Astro\Desktop\chat api\pwa-chatwoot\setup-apache.sh`
- Sunucu: `/path/to/pwa-chatwoot/setup-apache.sh`

### 2. SSH ile Sunucuya Bağlan

```bash
ssh kullanici@154.53.165.195
cd /path/to/pwa-chatwoot
```

### 3. Script'i Çalıştırılabilir Yap

```bash
chmod +x setup-apache.sh
```

### 4. Script'i Çalıştır

```bash
sudo ./setup-apache.sh
```

**Veya direkt:**

```bash
sudo bash setup-apache.sh
```

## 📝 Script Çıktısı

Script çalıştığında şunları göreceksiniz:

```
╔════════════════════════════════════════╗
║   BLXChat Apache Setup Script          ║
╚════════════════════════════════════════╝

✅ Proje klasörü: /var/www/html
📦 Apache kurulumu kontrol ediliyor...
✅ Apache kurulu!
🔧 mod_rewrite kontrol ediliyor...
✅ mod_rewrite aktif!
🔍 Apache portu kontrol ediliyor...
✅ Apache portu: 80
📝 Apache virtual host kontrol ediliyor...
✅ Virtual host yapılandırıldı!
📁 Dosya yapısı kontrol ediliyor...
✅ .htaccess mevcut
✅ dist/ klasörü mevcut
✅ public/ klasörü mevcut
✅ public/inbox-settings.json mevcut
🔐 Dosya izinleri düzenleniyor...
✅ İzinler düzenlendi!
🧪 Apache yapılandırması test ediliyor...
✅ Apache yapılandırması doğru!
🚀 Apache başlatılıyor...
📊 Apache durumu kontrol ediliyor...
✅ Apache çalışıyor!
🔍 Port kontrol ediliyor...
✅ Apache 80 portunda dinliyor!
🧪 Test isteği gönderiliyor...
✅ Apache yanıt veriyor!

╔════════════════════════════════════════╗
║   ✅ KURULUM TAMAMLANDI!              ║
╚════════════════════════════════════════╝

📋 Özet:
   Proje klasörü: /var/www/html
   Apache portu: 80
   Apache durumu: Çalışıyor

⚠️  Nginx Proxy Manager'da Forward Port'u 80 olarak ayarlayın!

🧪 Test URL'leri:
   http://localhost/
   http://localhost/test232
   http://localhost/admin/

📝 Log dosyaları:
   Error log: /var/log/apache2/error.log
   Access log: /var/log/apache2/access.log

Başarılar! 🎉
```

## ⚠️ Önemli Notlar

1. **Root yetkisi gerekli:** Script `sudo` ile çalıştırılmalı
2. **Proje klasörü:** Script otomatik olarak proje klasörünü bulmaya çalışır
3. **Build gerekli:** Eğer `dist/` klasörü yoksa, script uyarı verecek. Lokalde `npm run build` yapıp `dist/` klasörünü yüklemeniz gerekiyor.

## 🐛 Sorun Giderme

### Script "Permission denied" hatası veriyor

```bash
chmod +x setup-apache.sh
```

### Script "command not found" hatası veriyor

```bash
sudo bash setup-apache.sh
```

### Apache başlamıyor

```bash
# Apache error log'u kontrol et
sudo tail -f /var/log/apache2/error.log
```

### Port bulunamıyor

Script varsayılan olarak port 80 kullanır. Eğer farklı bir port kullanıyorsanız, script sonunda gösterilen portu Nginx Proxy Manager'da ayarlayın.

## 🔄 Script'i Tekrar Çalıştırma

Script'i istediğiniz zaman tekrar çalıştırabilirsiniz. Mevcut ayarları kontrol eder ve eksik olanları düzenler.

## 📋 Script Sonrası Yapılacaklar

1. ✅ Script başarıyla tamamlandı mı kontrol et
2. ✅ Apache portunu not al (genellikle 80)
3. ✅ Nginx Proxy Manager'a git
4. ✅ Forward Port'u script'in gösterdiği port olarak ayarla
5. ✅ Test et: `http://domain.com/test232`

## 🎯 Hızlı Komutlar

```bash
# Script'i çalıştır
sudo ./setup-apache.sh

# Apache durumunu kontrol et
sudo systemctl status apache2

# Apache portunu kontrol et
sudo netstat -tlnp | grep apache

# Apache error log'u izle
sudo tail -f /var/log/apache2/error.log

# Apache'yi restart et
sudo systemctl restart apache2
```

**Başarılar! 🎉**

