# 📤 Subdomain Kaldırma - Sunucu Güncelleme Rehberi

## ✅ Değiştirilen Dosyalar

1. `src/App.jsx` - Subdomain kontrolü kaldırıldı
2. `src/api/blxchat.js` - Subdomain kontrolü kaldırıldı
3. `index.html` - Manifest script'inde subdomain kontrolü kaldırıldı

## 🚀 Sunucuya Yükleme Yöntemleri

### Yöntem 1: Lokalde Build + dist/ Klasörünü Yükle (Önerilen)

#### 1. Lokalde Build Yap

```bash
cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"
npm run build
```

#### 2. Sunucuya Yüklenecek Dosyalar

**WinSCP veya SFTP ile yükle:**

- `dist/index.html` → `/path/to/pwa-chatwoot/dist/index.html` (üzerine yaz)
- `dist/assets/*.js` → `/path/to/pwa-chatwoot/dist/assets/` (tüm JavaScript dosyaları)

**Not:** `dist/assets/` klasöründeki JavaScript dosyaları build sırasında hash'lenmiş isimlerle oluşur (örn: `index-GMkk30o9.js`). Tüm `*.js` dosyalarını yükleyin.

### Yöntem 2: Sunucuda Build Yap

#### 1. Source Dosyalarını Sunucuya Yükle

**WinSCP veya SFTP ile yükle:**

- `src/App.jsx` → `/path/to/pwa-chatwoot/src/App.jsx` (üzerine yaz)
- `src/api/blxchat.js` → `/path/to/pwa-chatwoot/src/api/blxchat.js` (üzerine yaz)
- `index.html` → `/path/to/pwa-chatwoot/index.html` (üzerine yaz)

#### 2. Sunucuda Build Yap

SSH ile sunucuya bağlanın:

```bash
ssh kullanici@154.53.165.195
cd /path/to/pwa-chatwoot
# veya
cd /srv/blxchat

# Build yap
npm run build
```

## 📋 Kontrol Listesi

- [ ] Lokalde build yapıldı (`npm run build`)
- [ ] `dist/index.html` güncel
- [ ] `dist/assets/*.js` dosyaları güncel
- [ ] Sunucuya yüklendi
- [ ] Apache restart edildi (gerekirse)
- [ ] Test edildi: `http://domain.com/test1234`

## 🧪 Test

### 1. Sunucuda Test

```bash
# SSH ile sunucuya bağlan
ssh kullanici@154.53.165.195

# dist/index.html'in güncel olduğunu kontrol et
grep "sadece path'ten" /path/to/pwa-chatwoot/dist/index.html

# Eğer grep sonuç vermezse, dosya eski olabilir
```

### 2. Tarayıcıda Test

- `http://domain.com/test1234` → Console'da `📌 Path'den inbox ID bulundu: test1234` görünmeli
- `https://api.blxchat.lol/test1234` → Artık `api` subdomain'i görmezden gelinmeli, `test1234` algılanmalı

## 🔄 Apache Restart (Gerekirse)

Eğer dosyalar yüklendikten sonra değişiklikler görünmüyorsa:

```bash
sudo systemctl restart apache2
```

## 📝 Özet

**En kolay yöntem:**
1. Lokalde `npm run build` yap
2. `dist/` klasörünün tüm içeriğini sunucuya yükle
3. Test et

**Dosya yolları:**
- Lokal: `C:\Users\Astro\Desktop\chat api\pwa-chatwoot\dist\`
- Sunucu: `/path/to/pwa-chatwoot/dist/` veya `/srv/blxchat/dist/`

**Başarılar! 🎉**

