# Subdomain Yapılandırma Rehberi

Her inbox için subdomain kullanımı (örn: `inbox1.chat.example.com`)

## Cloudflare CNAME Ayarları

Cloudflare DNS'de şu CNAME kayıtlarını oluşturun:

```
Type: CNAME
Name: *
Target: chat.example.com
Proxy: ✅ (Enabled - Cloudflare CDN kullanmak için)
TTL: Auto
```

Bu wildcard CNAME kaydı, tüm subdomain'leri sunucunuza yönlendirecek:
- `inbox1.chat.example.com` → `chat.example.com`
- `inbox2.chat.example.com` → `chat.example.com`
- `cNjexMopP14ddG1DNc5czzcC.chat.example.com` → `chat.example.com`

## Sunucu Tarafı Yapılandırma

### 1. Nginx Konfigürasyonu

`nginx-subdomain.conf` dosyasını kullanın:

```bash
# Nginx config dosyasını kopyala
sudo cp nginx-subdomain.conf /etc/nginx/sites-available/chat-subdomain

# Symlink oluştur
sudo ln -s /etc/nginx/sites-available/chat-subdomain /etc/nginx/sites-enabled/

# Nginx'i test et
sudo nginx -t

# Nginx'i yeniden yükle
sudo systemctl reload nginx
```

**Önemli:** `chat.example.com` kısımlarını kendi domain'inizle değiştirin!

### 2. SSL Sertifikası (Let's Encrypt)

Wildcard SSL sertifikası için:

```bash
# Certbot ile wildcard sertifika al
sudo certbot certonly --dns-cloudflare \
  --dns-cloudflare-credentials ~/.secrets/cloudflare.ini \
  -d "*.chat.example.com" \
  -d "chat.example.com"
```

**Not:** Cloudflare DNS challenge kullanılıyor. Alternatif olarak manuel DNS challenge da kullanabilirsiniz.

### 3. Dosya Yapısı

```
/var/www/chat/
├── dist/              # React build dosyaları
├── admin/             # Admin panel
└── public/
    ├── logos/         # Yüklenen icon'lar
    └── inbox-settings.json
```

## Nasıl Çalışıyor?

1. **Kullanıcı:** `inbox1.chat.example.com` adresine gider
2. **Cloudflare:** Wildcard CNAME ile isteği sunucunuza yönlendirir
3. **Nginx:** Wildcard subdomain'i yakalar (`*.chat.example.com`)
4. **React App:** JavaScript'te subdomain'den inbox ID'yi çıkarır:
   ```javascript
   // hostname: "inbox1.chat.example.com"
   // Çıkarılan inbox ID: "inbox1"
   ```
5. **Uygulama:** Inbox ID'ye göre ayarları yükler ve chat'i gösterir

## Örnek Kullanım

### Inbox Oluşturma
Admin panelden yeni inbox ekleyin:
- **Inbox ID:** `inbox1`
- **App Name:** `A Firması Chat`
- **Logo:** `https://example.com/logo.png`

### Erişim
- **URL:** `https://inbox1.chat.example.com`
- **PWA:** Ana ekrana ekle → `inbox1.chat.example.com` olarak kaydedilir
- **Ayar:** Her inbox için farklı logo, isim, renk

## Test Etme

1. **DNS kontrolü:**
   ```bash
   dig inbox1.chat.example.com
   # CNAME kaydını göstermeli
   ```

2. **Tarayıcıda test:**
   - `http://inbox1.chat.example.com` açın
   - Console'da `📌 Subdomain'den inbox ID bulundu: inbox1` mesajını görün
   - Logo ve ayarlar doğru yüklenmeli

3. **PWA testi:**
   - Subdomain üzerinden "Ana ekrana ekle"
   - PWA açıldığında doğru inbox'a yönlenmeli

## Sorun Giderme

### Subdomain çalışmıyor
- DNS propagation'ı bekleyin (5-10 dakika)
- `nslookup inbox1.chat.example.com` ile DNS'i kontrol edin
- Cloudflare proxy durumunu kontrol edin

### SSL hatası
- Wildcard sertifikanın doğru yüklendiğinden emin olun
- Certbot ile sertifikayı yenileyin: `sudo certbot renew`

### 404 hatası
- Nginx config'i doğru mu kontrol edin
- `dist` klasörünün path'i doğru mu?
- Nginx loglarını kontrol edin: `sudo tail -f /var/log/nginx/chat-error.log`

## Alternatif: Path Bazlı Routing (Mevcut Sistem)

Eğer subdomain kullanmak istemiyorsanız, mevcut path bazlı sistem çalışmaya devam eder:
- `chat.example.com/inbox1`
- `chat.example.com/cNjexMopP14ddG1DNc5czzcC`

Her iki yöntem de aynı anda çalışabilir!

