# Sunucuya Yüklenecek Dosyalar Listesi

## ⚠️ ÖNEMLİ: Önce Build Edin!

**Firebase SDK yeni eklendi, mutlaka build edin:**

```bash
cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"
npm install
npm run build
```

## 📦 Yüklenecek Dosyalar ve Klasörler

### 1. Build Edilmiş Frontend (ZORUNLU!)

**Yüklenecek:**
- ✅ `dist/` klasörü (tüm içeriği)
  - `dist/assets/` - JavaScript ve CSS dosyaları (Firebase SDK dahil)
  - `dist/index.html` - Ana HTML dosyası

### 2. Public Klasörü (ZORUNLU!)

**Yüklenecek:**
- ✅ `public/firebase-messaging-sw.js` ⭐ YENİ (FCM Service Worker)
- ✅ `public/api/` klasörü (tüm içeriği)
  - `public/api/fcm-token.php` ⭐ YENİ (FCM token kaydetme)
  - `public/api/fcm-send.php` ⭐ YENİ (FCM bildirim gönderme)
- ✅ `public/inbox-settings.json` (güncellenmiş, FCM config ile)
- ✅ `public/users.json`
- ✅ `public/companies.json`
- ✅ `public/admin-config.json` (FCM Server Key ile güncellenmiş)
- ✅ `public/service-worker.js` (eski, yine de yükle)
- ✅ `public/manifest.json`
- ✅ `public/logos/` klasörü (tüm logo dosyaları)

### 3. Admin Klasörü (ZORUNLU!)

**Yüklenecek:**
- ✅ `admin/index.php` (FCM ayarları ile güncellenmiş)

### 4. Root Dosyalar (ZORUNLU!)

**Yüklenecek:**
- ✅ `.htaccess` (Apache configuration)
- ✅ `index.html` (root'ta, eğer varsa)

### 5. Icon Dosyaları (Opsiyonel ama önerilir)

**Yüklenecek (eğer varsa):**
- `icon-192.png` (PWA icon)
- `icon-512.png` (PWA icon)
- `favicon.png` (favicon)

## ❌ YÜKLENMEYECEK Dosyalar

- ❌ `node_modules/` (build edilmiş dosyalar yeterli)
- ❌ `src/` (build edilmiş dosyalar dist/ içinde)
- ❌ `package.json` (sunucuda gerekli değil)
- ❌ `package-lock.json`
- ❌ `vite.config.js`
- ❌ `.git/` klasörü
- ❌ `*.md` dosyaları (dokümantasyon, isteğe bağlı)
- ❌ `docker-compose.yml`, `Dockerfile` (Docker kullanmıyorsanız)
- ❌ `server/` klasörü (Node.js server, kullanmıyorsanız)

## 📋 Detaylı Dosya Listesi

```
Sunucuya yüklenecek dosyalar:

pwa-chatwoot/
├── dist/                          ✅ ZORUNLU (Build edilmiş frontend)
│   ├── assets/                    ✅ JavaScript ve CSS dosyaları
│   │   └── main-*.js              ✅ Firebase SDK dahil
│   └── index.html                 ✅ Ana HTML
│
├── public/                        ✅ ZORUNLU
│   ├── firebase-messaging-sw.js   ✅ YENİ (FCM Service Worker)
│   ├── api/                       ✅ ZORUNLU
│   │   ├── fcm-token.php         ✅ YENİ (FCM token kaydetme)
│   │   └── fcm-send.php          ✅ YENİ (FCM bildirim gönderme)
│   ├── inbox-settings.json        ✅ (FCM config ile güncellenmiş)
│   ├── users.json                 ✅
│   ├── companies.json             ✅
│   ├── admin-config.json          ✅ (FCM Server Key ile)
│   ├── service-worker.js          ✅ (eski, yine de yükle)
│   ├── manifest.json              ✅
│   └── logos/                     ✅ (tüm logo dosyaları)
│       └── *.png                  ✅
│
├── admin/                         ✅ ZORUNLU
│   └── index.php                  ✅ (FCM ayarları ile güncellenmiş)
│
├── .htaccess                      ✅ ZORUNLU (Apache configuration)
└── index.html                     ✅ (root'ta, eğer varsa)
```

## 🚀 Adım Adım Yükleme

### Adım 1: Build İşlemi (ÖNEMLİ!)

```bash
cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"
npm install
npm run build
```

**Kontrol edin:**
- `dist/assets/main-*.js` dosyası oluştu mu?
- Firebase SDK yüklendi mi? (dosya boyutu büyük olmalı)

### Adım 2: Dosyaları Sunucuya Yükleme

**WinSCP, FileZilla veya benzeri bir FTP/SFTP client kullanın:**

1. **dist/ klasörünü yükleyin:**
   - Lokal: `C:\Users\Astro\Desktop\chat api\pwa-chatwoot\dist\`
   - Sunucu: `/var/www/html/dist/` (veya web root'unuz)

2. **public/ klasörünü yükleyin:**
   - Lokal: `C:\Users\Astro\Desktop\chat api\pwa-chatwoot\public\`
   - Sunucu: `/var/www/html/public/`

3. **admin/ klasörünü yükleyin:**
   - Lokal: `C:\Users\Astro\Desktop\chat api\pwa-chatwoot\admin\`
   - Sunucu: `/var/www/html/admin/`

4. **.htaccess dosyasını yükleyin:**
   - Lokal: `C:\Users\Astro\Desktop\chat api\pwa-chatwoot\.htaccess`
   - Sunucu: `/var/www/html/.htaccess`

5. **index.html dosyasını yükleyin (eğer varsa):**
   - Lokal: `C:\Users\Astro\Desktop\chat api\pwa-chatwoot\index.html`
   - Sunucu: `/var/www/html/index.html`

### Adım 3: Dosya İzinlerini Ayarlayın (Linux Sunucu)

SSH ile sunucuya bağlanın ve şu komutları çalıştırın:

```bash
# PHP dosyaları için
chmod 644 public/api/*.php
chmod 644 admin/index.php

# JSON dosyaları için (yazılabilir olmalı)
chmod 666 public/inbox-settings.json
chmod 666 public/users.json
chmod 666 public/companies.json
chmod 666 public/admin-config.json
chmod 666 public/fcm-tokens.json  # Otomatik oluşturulacak (henüz yoksa oluşturulacak)

# Klasörler için
chmod 755 public/
chmod 755 public/api/
chmod 755 admin/
chmod 755 dist/
chmod 755 dist/assets/

# .htaccess için
chmod 644 .htaccess
```

### Adım 4: Kontrol Edin

1. **Sayfayı açın:** `https://your-domain.com/test232`
2. **Konsolu kontrol edin:** F12 > Console
3. **API çağrılarını kontrol edin:** Network sekmesi
4. **FCM token'ı kontrol edin:** `public/fcm-tokens.json` dosyası (otomatik oluşturulacak)

## 🔍 Kontrol Listesi

### Build Öncesi
- [ ] `npm install` çalıştırıldı mı?
- [ ] Firebase SDK yüklendi mi? (`node_modules/firebase/` var mı?)

### Build Sonrası
- [ ] `npm run build` çalıştırıldı mı?
- [ ] `dist/assets/main-*.js` dosyası oluştu mu?
- [ ] `dist/index.html` dosyası güncel mi?

### Yükleme Sonrası
- [ ] `dist/` klasörü yüklendi mi?
- [ ] `public/firebase-messaging-sw.js` yüklendi mi?
- [ ] `public/api/fcm-token.php` yüklendi mi?
- [ ] `public/api/fcm-send.php` yüklendi mi?
- [ ] `admin/index.php` güncellenmiş mi?
- [ ] `.htaccess` dosyası yüklendi mi?
- [ ] JSON dosyaları yazılabilir mi? (chmod 666)
- [ ] PHP dosyaları çalışıyor mu?
- [ ] Sayfa açılıyor mu?
- [ ] Mesajlar Chatwoot'a gidiyor mu?
- [ ] FCM token alınıyor mu?

## 🚨 Önemli Notlar

### 1. Build İşlemi Zorunlu

**Build edilmeden yüklerseniz:**
- ❌ Firebase SDK yüklenmemiş olur
- ❌ FCM çalışmaz
- ❌ Frontend düzgün çalışmaz
- ❌ Mesajlar Chatwoot'a gitmeyebilir

### 2. FCM Token Dosyası

`public/fcm-tokens.json` dosyası otomatik oluşturulacak. İlk kullanıcı sayfayı açtığında oluşur. Dosya yazılabilir olmalı (chmod 666).

### 3. CORS Ayarları

Eğer CORS hatası alırsanız, `.htaccess` dosyasında CORS ayarları var. Apache'de `mod_headers` modülünün aktif olduğundan emin olun.

### 4. PHP Extension'ları

Sunucuda şu PHP extension'ları aktif olmalı:
- ✅ `curl` (FCM API çağrıları için)
- ✅ `json` (JSON işlemleri için)

### 5. HTTPS Gereksinimi

FCM için HTTPS gerekli (localhost hariç). HTTP üzerinde çalışmaz.

### 6. Apache Modülleri

Apache'de şu modüller aktif olmalı:
- ✅ `mod_rewrite` (.htaccess için)
- ✅ `mod_headers` (CORS için)

## 🎯 Hızlı Özet

**Yüklenecek 4 ana klasör/dosya:**
1. ✅ `dist/` klasörü (build edilmiş frontend)
2. ✅ `public/` klasörü (API endpoint'leri, JSON dosyaları, Service Worker)
3. ✅ `admin/` klasörü (güncellenmiş admin panel)
4. ✅ `.htaccess` dosyası

**Toplam dosya sayısı:** ~20-30 dosya (logo dosyaları dahil)

## 📞 Sorun Giderme

### "Mesajlar Chatwoot'a gitmiyor" hatası

1. **BASE_URL kontrolü:**
   - Konsolda `🌐 API çağrısı:` log'una bakın
   - BASE_URL doğru mu? (`http://app.blxchat.lol`)
   - CORS hatası var mı?

2. **Inbox ID kontrolü:**
   - `chatwootInboxId` doğru mu? (`py4MWCqwdDcJP6q25ZipcdZF`)
   - Konsolda `🔗 Chatwoot inbox ID kullanılıyor:` log'una bakın

3. **API endpoint kontrolü:**
   - Network sekmesinde API çağrıları görünüyor mu?
   - Hata kodu nedir? (404, 403, 500, vb.)

### "FCM çalışmıyor" hatası

1. **Build kontrolü:**
   - `npm run build` çalıştırıldı mı?
   - `dist/assets/main-*.js` dosyası güncel mi?

2. **Service Worker kontrolü:**
   - `public/firebase-messaging-sw.js` yüklendi mi?
   - Konsolda Service Worker kayıtlı mı?

3. **FCM Config kontrolü:**
   - Firebase Config doğru mu?
   - VAPID Key doğru mu?
   - FCM Server Key `admin-config.json`'da var mı?

## ✅ Başarılı Yükleme

Eğer her şey doğru yüklendiyse:

1. ✅ Sayfa açılıyor
2. ✅ Mesajlar Chatwoot'a gidiyor
3. ✅ FCM token alınıyor
4. ✅ Test bildirimi gönderiliyor
5. ✅ Bildirim geliyor

## 🔗 Sonraki Adımlar

1. Build edin: `npm run build`
2. Dosyaları sunucuya yükleyin
3. Dosya izinlerini ayarlayın
4. Sayfayı test edin
5. FCM token'ı kontrol edin
6. Test bildirimi gönderin
