# 📤 Sunucuya Yüklenecek Dosyalar

Normal çalıştırma için (Docker olmadan) sunucuda güncellenmesi gereken dosyalar:

## ✅ Zorunlu Dosyalar

### 1. `.htaccess` (ÖNEMLİ - Mutlaka güncelle!)
**Konum:** Proje root'unda (`/path/to/pwa-chatwoot/.htaccess`)

Bu dosya SPA routing için kritik. Yeni versiyonu sunucuya yükleyin.

### 2. `dist/` Klasörü (Build sonrası)
**Konum:** Proje root'unda (`/path/to/pwa-chatwoot/dist/`)

Lokalde build yapıp `dist/` klasörünü sunucuya yükleyin:

```bash
# Lokalde build yap
npm run build

# dist/ klasörünü sunucuya yükle
```

### 3. `vite.config.js` (Opsiyonel - Sadece sunucuda build yapacaksanız)
**Konum:** Proje root'unda (`/path/to/pwa-chatwoot/vite.config.js`)

Eğer sunucuda build yapacaksanız bu dosyayı da güncelleyin. Ama önerilen: Lokalde build yapıp `dist/` klasörünü yüklemek.

## 📋 Adım Adım Yükleme

### Yöntem 1: Lokalde Build + Sadece Gerekli Dosyaları Yükle (Önerilen)

```bash
# 1. Lokalde build yap
npm run build

# 2. Sunucuya yüklenecek dosyalar:
#    - .htaccess (güncellenmiş)
#    - dist/ klasörü (tüm içeriği)
#    - public/ klasörü (zaten varsa güncelleme gerekmez, ama kontrol et)
```

**WinSCP veya SFTP ile yükle:**
- `.htaccess` → `/path/to/pwa-chatwoot/.htaccess`
- `dist/` klasörü → `/path/to/pwa-chatwoot/dist/` (tüm içeriği)

### Yöntem 2: Sunucuda Build Yap

```bash
# SSH ile sunucuya bağlan
ssh kullanici@sunucu-ip
cd /path/to/pwa-chatwoot

# 1. vite.config.js dosyasını güncelle (lokalden yükle)

# 2. Build yap
npm run build

# 3. .htaccess dosyasını güncelle (lokalden yükle)
```

## 🔍 Kontrol Listesi

Yükleme sonrası kontrol edin:

- [ ] `.htaccess` dosyası root'ta ve güncel
- [ ] `dist/` klasörü mevcut ve içinde dosyalar var
- [ ] `dist/index.html` dosyası var
- [ ] `public/` klasörü mevcut
- [ ] `public/inbox-settings.json` dosyası var
- [ ] Apache `mod_rewrite` aktif
- [ ] Apache config'de `AllowOverride All`

## 🧪 Test

```bash
# Sunucuda test et
curl http://domain.com/test232
# veya tarayıcıda: http://domain.com/test232
```

## 📝 Dosya Yapısı (Sunucuda Olması Gereken)

```
pwa-chatwoot/
├── .htaccess          ← GÜNCELLE (yeni)
├── dist/              ← GÜNCELLE (build sonrası)
│   ├── index.html
│   ├── assets/
│   │   ├── *.js
│   │   └── *.css
│   └── ...
├── admin/             ← Değişiklik yok
│   └── index.php
├── public/            ← Değişiklik yok (ama kontrol et)
│   ├── inbox-settings.json
│   ├── companies.json
│   ├── users.json
│   ├── admin-config.json
│   └── logos/
├── index.html         ← Değişiklik yok
└── vite.config.js     ← Opsiyonel (sadece sunucuda build yapacaksanız)
```

## ⚠️ Önemli Notlar

1. **`.htaccess` mutlaka güncellenmeli** - SPA routing için kritik
2. **`dist/` klasörü build sonrası oluşur** - Lokalde build yapıp yüklemeniz önerilir
3. **`public/` klasörü zaten varsa** - Güncelleme gerekmez (JSON dosyaları korunur)
4. **Apache `mod_rewrite` aktif olmalı** - Kontrol edin:
   ```bash
   sudo a2enmod rewrite
   sudo systemctl restart apache2
   ```

## 🚀 Hızlı Komutlar

### Lokalde Build
```bash
npm run build
```

### Sunucuya Yükleme (WinSCP/SFTP)
1. `.htaccess` → `/path/to/pwa-chatwoot/.htaccess` (üzerine yaz)
2. `dist/` klasörü → `/path/to/pwa-chatwoot/dist/` (tüm içeriği)

### Sunucuda Kontrol
```bash
# .htaccess var mı?
ls -la /path/to/pwa-chatwoot/.htaccess

# dist/ klasörü var mı?
ls -la /path/to/pwa-chatwoot/dist/

# Apache restart (gerekirse)
sudo systemctl restart apache2
```

## 🐛 Sorun Giderme

### Sorun: "404 Not Found"
- `.htaccess` dosyası güncel mi kontrol et
- `dist/` klasörü var mı kontrol et
- Apache `mod_rewrite` aktif mi kontrol et

### Sorun: "Internal Server Error"
- Apache error log kontrol et: `tail -f /var/log/apache2/error.log`
- `.htaccess` syntax hatası olabilir

### Sorun: JSON dosyaları yüklenmiyor
- `public/inbox-settings.json` var mı kontrol et
- `.htaccess` JSON rewrite kuralları doğru mu kontrol et

**Başarılar! 🎉**

