# Demo Test Rehberi

## Hızlı Test

1. **Development server'ı başlatın:**
   ```bash
   cd pwa-chatwoot
   npm run dev
   ```

2. **Farklı inbox URL'leri ile test edin:**

   - **A Firması** (Yeşil tema):
     ```
     http://localhost:5173/test-firma-a
     ```
     - Logo: A Firması Chat
     - Renk: Yeşil (#059669)
     - Mesaj: "A Firması'na hoş geldiniz!"

   - **B Firması** (Kırmızı tema):
     ```
     http://localhost:5173/test-firma-b
     ```
     - Logo: B Firması Chat
     - Renk: Kırmızı (#dc2626)
     - Mesaj: "B Firması'na hoş geldiniz!"

   - **C Firması** (Mor tema):
     ```
     http://localhost:5173/test-firma-c
     ```
     - Logo: C Firması Chat
     - Renk: Mor (#7c3aed)
     - Mesaj: "C Firması'na hoş geldiniz!"

   - **Gerçek Betlabx Inbox** (Mavi tema):
     ```
     http://localhost:5173/mdo5jWFdoJ6mnhij3FkBPJb3
     ```
     - Logo: Betlabx Chat
     - Renk: Mavi (#1e40af)
     - Mesaj: "Betlabx'e hoş geldiniz!"

## Ne Test Edilecek?

1. ✅ Her inbox için farklı logo ve isim görünmeli
2. ✅ Her inbox için farklı renk teması olmalı (butonlar, mesaj baloncukları)
3. ✅ Sayfa başlığı (title) inbox'a göre değişmeli
4. ✅ Arka plan rengi değişmeli
5. ✅ URL değiştiğinde ayarlar otomatik yenilenmeli

## Yeni Inbox Ekleme

`public/inbox-settings.json` dosyasına yeni inbox ekleyebilirsiniz:

```json
{
  "yeni-inbox-id": {
    "appName": "Yeni Firma Chat",
    "logoUrl": "/icon-192.png",
    "welcomeMessage": "👋 Hoş geldiniz!",
    "supportEmail": "support@yeni-firma.com",
    "theme": {
      "primaryColor": "#f59e0b",
      "secondaryColor": "#fbbf24",
      "backgroundColor": "#0f172a"
    }
  }
}
```

Sonra şu URL'yi açın:
```
http://localhost:5173/yeni-inbox-id
```

## Production için

Production'da `VITE_SETTINGS_API_URL` environment variable'ını ayarlayın:

```bash
VITE_SETTINGS_API_URL=https://api.example.com
```

Böylece local JSON yerine gerçek API kullanılacak.

