# 🔧 Vite Dev Server JSON Dosyası Sorunu Çözümü

## 🔴 Sorun

Localhost'ta (`http://localhost:5173/test232`) çalışırken:
- ❌ `inbox-settings.json` dosyası yüklenemiyor
- ❌ HTML dönüyor (`<!doctype` hatası)
- ❌ `BASE_URL` boş kalıyor

## ✅ Çözüm

### 1. Vite Middleware Sırası Düzeltildi

**Sorun:** Vite'ın `configureServer` hook'u yanlış kullanılıyordu. Middleware, Vite'ın kendi static file serving'inden önce çalışıyordu.

**Çözüm:** `configureServer` hook'undan bir fonksiyon döndürülüyor. Bu fonksiyon, Vite'ın kendi middleware'leri kurulduktan sonra çalışıyor.

```javascript
configureServer(server) {
  // Return a function that will be called after Vite's middleware is set up
  return () => {
    server.middlewares.use((req, res, next) => {
      // ... middleware logic
    });
  };
}
```

### 2. JSON Response Kontrolü Eklendi

**Sorun:** Response'un JSON olduğu kontrol edilmiyordu.

**Çözüm:** Response'un `content-type` header'ı kontrol ediliyor. Eğer HTML döndüyse, `/public/` path'i deneniyor.

```javascript
if (!response.ok || response.headers.get('content-type')?.includes('text/html')) {
  // /public/ path'ini dene
}
```

### 3. Detaylı Hata Mesajları

**Sorun:** Hata mesajları yeterince açıklayıcı değildi.

**Çözüm:** Detaylı console log'ları ve hata mesajları eklendi.

## 🚀 Test Et

### 1. Dev Server'ı Yeniden Başlat

```bash
# Dev server'ı durdurun (Ctrl+C)
# Sonra tekrar başlatın
cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"
npm run dev
```

### 2. Browser Console Kontrolü

F12 > Console'u açın:

**Başarılı:**
```
📋 JSON dosyası okundu, inbox: test232 bulundu: true
🔧 Chatwoot Base URL güncelleniyor: https://app.blxchat.lol
🌐 Chatwoot Base URL güncellendi: https://app.blxchat.lol
```

**Hata (Eski):**
```
⚠️ /inbox-settings.json bulunamadı veya HTML döndü, /public/ path deneniyor...
❌ Response JSON değil, HTML döndü: text/html
```

### 3. Network Sekmesi Kontrolü

F12 > Network:
- `/inbox-settings.json` isteği başarılı olmalı
- Status: `200 OK`
- Content-Type: `application/json` (HTML değil!)

### 4. Doğrudan URL Testi

Tarayıcıda şu URL'leri açın:

1. `http://localhost:5173/inbox-settings.json`
   - ✅ JSON formatında görünmeli
   - ❌ HTML görünmemeli

2. `http://localhost:5173/public/inbox-settings.json`
   - ✅ JSON formatında görünmeli (fallback)

## 🔍 Sorun Giderme

### "Hala HTML dönüyor"

1. **Dev server'ı yeniden başlatın:**
   ```bash
   # Ctrl+C ile durdurun
   npm run dev
   ```

2. **Browser cache'ini temizleyin:**
   - Ctrl+Shift+Delete
   - Cache'i temizle
   - Sayfayı yenile (Ctrl+F5)

3. **Vite config'i kontrol edin:**
   - `vite.config.js` dosyasında middleware sırası doğru mu?
   - `configureServer` hook'u bir fonksiyon döndürüyor mu?

### "JSON dosyası hala yüklenemiyor"

1. **Dosya var mı kontrol edin:**
   ```bash
   # Windows PowerShell
   Test-Path "public\inbox-settings.json"
   ```

2. **Doğrudan URL'yi test edin:**
   - `http://localhost:5173/inbox-settings.json`
   - JSON formatında görünmeli

3. **Vite dev server log'larını kontrol edin:**
   - Terminal'de hata var mı?
   - Port 5173 kullanımda mı?

### "BASE_URL hala boş"

1. **JSON dosyasında chatwootBaseUrl var mı?**
   ```json
   {
     "test232": {
       "chatwootBaseUrl": "https://app.blxchat.lol"
     }
   }
   ```

2. **Console'da kontrol edin:**
   - `📋 JSON dosyası okundu` mesajı görünüyor mu?
   - `🔧 Chatwoot Base URL güncelleniyor` mesajı görünüyor mu?

## ✅ Başarılı Çözüm

Eğer her şey doğru yapıldıysa:

1. ✅ JSON dosyası yüklendi (`📋 JSON dosyası okundu`)
2. ✅ `chatwootBaseUrl` okundu
3. ✅ `BASE_URL` güncellendi: `https://app.blxchat.lol`
4. ✅ API çağrıları `app.blxchat.lol` üzerinden
5. ✅ `call.betlabx.com` hiçbir yerde görünmüyor

## 📋 Kontrol Listesi

- [ ] Dev server yeniden başlatıldı
- [ ] Browser cache temizlendi
- [ ] `/inbox-settings.json` doğrudan erişilebilir (JSON formatında)
- [ ] JSON dosyası yüklendi (`📋 JSON dosyası okundu`)
- [ ] BASE_URL güncellendi (`🌐 Chatwoot Base URL güncellendi`)
- [ ] API çağrıları `app.blxchat.lol` üzerinden
- [ ] `call.betlabx.com` görünmüyor

## 🔗 İlgili Dosyalar

- `vite.config.js` - Middleware sırası (güncellenmiş)
- `src/App.jsx` - JSON dosyası yükleme (güncellenmiş)
- `src/api/blxchat.js` - JSON dosyası yükleme (güncellenmiş)
- `public/inbox-settings.json` - Chatwoot Base URL burada

## 💡 Not

Vite'da `public/` klasöründeki dosyalar otomatik olarak root'tan serve edilir. Ancak SPA routing middleware'i bunu engelliyorsa, middleware sırasını düzeltmek gerekir.

