# 📤 Windows'tan Portainer'a Dosya Yükleme Rehberi

## 🎯 En Kolay Yöntemler

### YÖNTEM 1: Portainer Web UI ile Dosya Yükleme (Önerilen)

#### Adım 1: Dosyaları Hazırlama

1. Windows'ta proje klasörünü açın: `C:\Users\Astro\Desktop\chat api\pwa-chatwoot`
2. Tüm dosyaları bir ZIP dosyasına sıkıştırın:
   - Klasöre sağ tıklayın
   - **Send to** > **Compressed (zipped) folder**
   - Veya WinRAR/7-Zip kullanın

#### Adım 2: Portainer'da Stack Oluşturma

1. Portainer'a giriş yapın
2. **Stacks** > **Add stack**
3. **Name**: `blxchat`
4. **Build method**: **Web editor** seçin

#### Adım 3: Docker Compose Yapıştırma

Aşağıdaki kodu yapıştırın:

```yaml
version: '3.8'

services:
  blxchat:
    build:
      context: .
      dockerfile: Dockerfile
    image: blxchat:latest
    container_name: blxchat
    restart: unless-stopped
    ports:
      - "8080:80"
    volumes:
      - ./public:/var/www/html/public
    environment:
      - NODE_ENV=production
    networks:
      - blxchat-network

networks:
  blxchat-network:
    driver: bridge
```

#### Adım 4: Dosyaları Yükleme

**⚠️ ÖNEMLİ**: Portainer'ın bazı versiyonlarında "Upload files" butonu olmayabilir. Bu durumda aşağıdaki alternatif yöntemleri kullanın.

---

### YÖNTEM 2: Git Repository Kullanma (En Pratik)

#### Adım 1: GitHub'a Push Etme

1. **GitHub Desktop** veya **Git Bash** kullanın:

```bash
# Git Bash'te (Windows'ta Git kurulu olmalı)
cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"

# Git repository başlat (eğer yoksa)
git init

# Dosyaları ekle
git add .

# Commit yap
git commit -m "Initial commit"

# GitHub'da yeni repository oluşturun, sonra:
git remote add origin https://github.com/KULLANICI_ADI/blxchat.git
git branch -M main
git push -u origin main
```

#### Adım 2: Portainer'da Repository Kullanma

1. Portainer'da **Stacks** > **Add stack**
2. **Build method**: **Repository** seçin
3. **Repository URL**: `https://github.com/KULLANICI_ADI/blxchat.git`
4. **Compose path**: `docker-compose.yml`
5. **Reference**: `main`
6. **Deploy the stack**

---

### YÖNTEM 3: SCP/SFTP ile Sunucuya Yükleme

#### Adım 1: WinSCP veya FileZilla Kurma

1. **WinSCP** indirin: https://winscp.net/
2. Veya **FileZilla** kullanın: https://filezilla-project.org/

#### Adım 2: Sunucuya Bağlanma

1. WinSCP'yi açın
2. Yeni bağlantı oluşturun:
   - **Host name**: Sunucu IP veya domain
   - **Port**: 22 (SSH)
   - **User name**: Kullanıcı adı
   - **Password**: Şifre
3. **Login** butonuna tıklayın

#### Adım 3: Dosyaları Yükleme

1. Sol tarafta Windows klasörünüzü bulun: `C:\Users\Astro\Desktop\chat api\pwa-chatwoot`
2. Sağ tarafta sunucuda bir klasör seçin (örn: `/home/user/blxchat`)
3. Tüm dosyaları seçin ve **Upload** butonuna tıklayın

#### Adım 4: Portainer'da Volume Mount

Portainer'da stack oluştururken:

```yaml
services:
  blxchat:
    build:
      context: /home/user/blxchat  # Sunucudaki yol
      dockerfile: Dockerfile
    # ... diğer ayarlar
```

---

### YÖNTEM 4: Docker Volume ile (Gelişmiş)

#### Adım 1: Dosyaları Sunucuya Kopyalama

SCP ile (Windows PowerShell'de):

```powershell
# PowerShell'de
scp -r "C:\Users\Astro\Desktop\chat api\pwa-chatwoot\*" user@SUNUCU_IP:/home/user/blxchat/
```

#### Adım 2: Portainer'da Stack Oluşturma

1. **Stacks** > **Add stack**
2. **Build method**: **Web editor**
3. Docker compose'u yapıştırın
4. Build context'i sunucu yolu olarak ayarlayın

---

## 🚀 Hızlı Başlangıç: Git Kullanmadan

### Seçenek A: WinSCP ile (En Kolay)

1. **WinSCP** kurun ve sunucuya bağlanın
2. Proje klasörünü sunucuya yükleyin
3. Portainer'da stack oluştururken build context'i sunucu yolu olarak belirtin

### Seçenek B: Portainer File Browser (Eğer Varsa)

Bazı Portainer versiyonlarında:
1. **Volumes** > **Add volume**
2. Volume oluşturun: `blxchat-data`
3. **Browse** butonuna tıklayın
4. Dosyaları yükleyin

---

## 📋 Adım Adım: WinSCP ile Yükleme

### 1. WinSCP Kurulumu

1. https://winscp.net/ adresinden indirin
2. Kurulumu tamamlayın

### 2. Bağlantı Ayarları

```
File protocol: SFTP
Host name: SUNUCU_IP (veya domain)
Port number: 22
User name: root (veya kullanıcı adı)
Password: Şifreniz
```

### 3. Dosya Yükleme

1. **Sol panel**: Windows klasörünüz (`pwa-chatwoot`)
2. **Sağ panel**: Sunucu klasörü (örn: `/root/blxchat`)
3. Tüm dosyaları seçin (Ctrl+A)
4. **Upload** butonuna tıklayın (F5)

### 4. Portainer'da Stack Oluşturma

```yaml
version: '3.8'

services:
  blxchat:
    build:
      context: /root/blxchat  # WinSCP'de yüklediğiniz yol
      dockerfile: Dockerfile
    image: blxchat:latest
    container_name: blxchat
    restart: unless-stopped
    ports:
      - "8080:80"
    volumes:
      - /root/blxchat/public:/var/www/html/public
    networks:
      - blxchat-network

networks:
  blxchat-network:
    driver: bridge
```

---

## 🔧 Alternatif: PowerShell ile SCP

Windows 10/11'de PowerShell'de SCP komutu var:

```powershell
# PowerShell'i Administrator olarak açın
cd "C:\Users\Astro\Desktop\chat api\pwa-chatwoot"

# Tüm dosyaları sunucuya kopyala
scp -r * user@SUNUCU_IP:/home/user/blxchat/
```

---

## 📦 ZIP Dosyası ile Yükleme

### 1. ZIP Oluşturma

1. `pwa-chatwoot` klasörüne sağ tıklayın
2. **Send to** > **Compressed (zipped) folder**
3. `pwa-chatwoot.zip` oluşacak

### 2. WinSCP ile Yükleme

1. WinSCP'de sunucuya bağlanın
2. ZIP dosyasını yükleyin
3. Sunucuda SSH ile:

```bash
# SSH ile sunucuya bağlanın
cd /home/user
unzip pwa-chatwoot.zip
cd pwa-chatwoot
```

### 3. Portainer'da Stack Oluşturma

Build context: `/home/user/pwa-chatwoot`

---

## ✅ Kontrol Listesi

- [ ] WinSCP kuruldu ve bağlantı yapıldı
- [ ] Tüm dosyalar sunucuya yüklendi
- [ ] Portainer'da stack oluşturuldu
- [ ] Build context doğru yolu gösteriyor
- [ ] Container başarıyla çalışıyor

---

## 🆘 Sorun Giderme

### "Permission denied" Hatası

```bash
# SSH ile sunucuya bağlanın
chmod -R 755 /home/user/blxchat
```

### "Cannot find Dockerfile" Hatası

- Build context yolunu kontrol edin
- Dockerfile'ın o klasörde olduğundan emin olun

### Dosyalar Eksik

- WinSCP'de **Synchronize** özelliğini kullanın
- Veya tekrar upload edin

---

## 💡 İpucu: Otomatik Senkronizasyon

WinSCP'de **Keep remote directory up to date** özelliğini kullanarak otomatik senkronizasyon yapabilirsiniz.

**Başarılar! 🎉**

