# Admin Panel Kullanım Rehberi

## Giriş

Admin paneline erişmek için:
```
http://localhost/admin/index.php
```

**Varsayılan Şifre:** `admin123`

⚠️ **ÖNEMLİ:** Production'a geçmeden önce şifreyi değiştirin! (`admin/index.php` dosyasındaki `$ADMIN_PASSWORD` değişkenini düzenleyin)

## Özellikler

### 1. Yeni Inbox Ekleme
- "➕ Yeni Inbox Ekle" butonuna tıklayın
- Inbox ID girin (URL'de kullanılacak, örn: `test-firma-a`)
- Firma adı, logo URL, hoş geldin mesajı gibi bilgileri doldurun
- Tema renklerini seçin
- "Inbox Ekle" butonuna tıklayın

### 2. Mevcut Inbox'ları Düzenleme
- Her inbox kartında bilgileri görüntüleyebilir ve düzenleyebilirsiniz
- Değişiklik yaptıktan sonra "💾 Kaydet" butonuna tıklayın
- Değişiklikler anında JSON dosyasına kaydedilir

### 3. Inbox Silme
- Silmek istediğiniz inbox'un yanındaki "🗑️ Sil" butonuna tıklayın
- Onay mesajı gelecek, onayladığınızda inbox silinir

### 4. Logo Yükleme
- Logo URL alanına direkt URL girebilirsiniz (örn: `https://example.com/logo.png`)
- Veya `public/logos/` klasörüne logo yükleyip `/logos/dosya.png` şeklinde kullanabilirsiniz

## Güvenlik İyileştirmeleri (Production için)

1. **Şifre Hash'leme:**
   ```php
   // Şifreyi hash'le
   $hashedPassword = password_hash('admin123', PASSWORD_DEFAULT);
   // Kontrol
   if (password_verify($_POST['password'], $hashedPassword)) {
       // Giriş başarılı
   }
   ```

2. **Veritabanı Kullanımı:**
   - JSON yerine MySQL/MariaDB kullanın
   - SQL injection'a karşı prepared statements kullanın

3. **CSRF Koruması:**
   - Her form için CSRF token ekleyin

4. **Rate Limiting:**
   - Çok fazla istekte bulunan IP'leri engelleyin

## Test Etme

1. Admin panele giriş yapın: `http://localhost/admin/index.php`
2. Yeni bir inbox ekleyin
3. Ayarları kaydedin
4. Test URL'ine gidin (örnek: `http://localhost:5173/test-inbox-1`)
5. Logo, renkler ve mesajların doğru göründüğünü kontrol edin

