#!/bin/bash
# Debian sunucuda Docker olmadan deploy etmek için script

echo "🚀 Betlabx Chat - Manual Deployment"
echo "===================================="

# 1. Node.js kurulu mu kontrol et ve kur
if ! command -v node &> /dev/null; then
    echo "📦 Node.js bulunamadı. Kurulum başlatılıyor..."
    
    # Sudo yetkisi kontrol et
    if ! sudo -n true 2>/dev/null; then
        echo "⚠️  Sudo yetkisi gerekiyor. Aşağıdaki komutları manuel çalıştırın:"
        echo ""
        echo "   curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -"
        echo "   sudo apt-get update"
        echo "   sudo apt-get install -y nodejs"
        echo ""
        echo "   Sonra tekrar: ./deploy-manual.sh"
        exit 1
    fi
    
    echo "📥 Node.js repository ekleniyor..."
    curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
    
    echo "📦 Node.js kuruluyor..."
    sudo apt-get update
    sudo apt-get install -y nodejs
    
    # Kurulum kontrolü
    if ! command -v node &> /dev/null; then
        echo "❌ Node.js kurulumu başarısız!"
        exit 1
    fi
    
    echo "✅ Node.js kuruldu!"
    node --version
    npm --version
    echo ""
fi

# 2. Dependencies kur
echo "📦 Dependencies kuruluyor..."
npm install

# 3. Production build al
echo "🏗️ Production build alınıyor..."
npm run build

# 4. Build başarılı mı kontrol et
if [ ! -d "dist" ]; then
    echo "❌ Build başarısız! dist klasörü oluşturulmadı."
    exit 1
fi

echo "✅ Build tamamlandı!"
echo ""
echo "📝 Çalıştırma seçenekleri:"
echo ""
echo "Seçenek 1 - Node.js ile (Basit):"
echo "   npm start"
echo "   veya"
echo "   pm2 start server-static.js --name betlabx-chat"
echo ""
echo "Seçenek 2 - Nginx ile (Önerilen):"
echo "   sudo mkdir -p /var/www/betlabx-chat"
echo "   sudo cp -r dist/* /var/www/betlabx-chat/"
echo "   sudo chown -R www-data:www-data /var/www/betlabx-chat"
echo "   sudo cp nginx-production.conf /etc/nginx/sites-available/betlabx-chat"
echo "   sudo ln -s /etc/nginx/sites-available/betlabx-chat /etc/nginx/sites-enabled/"
echo "   sudo nginx -t && sudo systemctl restart nginx"
echo ""
echo "📖 Detaylı rehber için: DEPLOY-MANUAL.md dosyasına bakın"
echo ""

