<?php
/**
 * FCM Token Kaydetme Endpoint
 * FCM token'larını inbox bazında saklar
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// OPTIONS request için
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// POST request kontrolü
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// JSON body'yi parse et
$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!$data || !isset($data['token']) || !isset($data['inboxId'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Token ve inboxId gerekli']);
    exit;
}

$token = $data['token'];
$inboxId = $data['inboxId'];
$url = $data['url'] ?? '';

// FCM token'larını sakla
$tokensFile = __DIR__ . '/../fcm-tokens.json';

// Mevcut token'ları yükle
$tokens = [];
if (file_exists($tokensFile)) {
    $tokens = json_decode(file_get_contents($tokensFile), true) ?: [];
}

// Token'ı inbox'e ekle (aynı token birden fazla inbox'te olabilir)
if (!isset($tokens[$inboxId])) {
    $tokens[$inboxId] = [];
}

// Token zaten varsa güncelle, yoksa ekle
$tokenExists = false;
foreach ($tokens[$inboxId] as $index => $tokenData) {
    if ($tokenData['token'] === $token) {
        $tokens[$inboxId][$index]['url'] = $url;
        $tokens[$inboxId][$index]['updated_at'] = date('Y-m-d H:i:s');
        $tokenExists = true;
        break;
    }
}

if (!$tokenExists) {
    $tokens[$inboxId][] = [
        'token' => $token,
        'url' => $url,
        'created_at' => date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s')
    ];
}

// Token'ları kaydet
file_put_contents($tokensFile, json_encode($tokens, JSON_PRETTY_PRINT), LOCK_EX);

echo json_encode([
    'success' => true,
    'message' => 'Token kaydedildi',
    'inboxId' => $inboxId,
    'tokenCount' => count($tokens[$inboxId])
]);

