import http from 'node:http';
import crypto from 'node:crypto';
import { config } from 'dotenv';
config();

const PORT = process.env.PORT || 3001;
const SECRET = process.env.SECRET || 'REPLACE_ME';

function sign(payload){
  return crypto.createHmac('sha256', SECRET).update(payload).digest('hex');
}

const server = http.createServer(async (req, res) => {
  if (req.method === 'POST' && req.url === '/sign'){
    let body='';
    req.on('data', c=> body += c);
    req.on('end', ()=>{
      try{
        const json = JSON.parse(body||'{}');
        const token = sign(JSON.stringify(json));
        res.writeHead(200, { 'Content-Type':'application/json', 'Access-Control-Allow-Origin':'*' });
        res.end(JSON.stringify({ token }));
      }catch(e){ res.writeHead(400).end('bad request'); }
    });
    return;
  }
  if (req.method === 'OPTIONS'){
    res.writeHead(204, { 'Access-Control-Allow-Origin':'*', 'Access-Control-Allow-Methods':'POST,GET,OPTIONS', 'Access-Control-Allow-Headers':'*' }).end();
    return;
  }
  res.writeHead(200, { 'Content-Type':'text/plain' });
  res.end('ok');
});

server.listen(PORT, ()=> console.log('HMAC server on', PORT));

