import { defineConfig } from 'vite';
import react from '@vitejs/plugin-react';

export default defineConfig({
  plugins: [
    react(),
    // SPA routing middleware - tüm path'leri index.html'e yönlendir
    // ÖNEMLİ: Bu middleware Vite'ın kendi static file serving'inden SONRA çalışmalı
    {
      name: 'spa-routing',
      configureServer(server) {
        // Vite'ın kendi middleware'lerinden sonra çalış (en son)
        // Return a function that will be called after Vite's middleware is set up
        return () => {
          server.middlewares.use((req, res, next) => {
            // Static dosyalar ve API istekleri için devam et
            // Vite zaten public/ klasöründeki dosyaları serve ediyor, bu yüzden kontrol etmemize gerek yok
            if (
              req.url?.startsWith('/src/') ||
              req.url?.startsWith('/node_modules/') ||
              req.url?.startsWith('/@vite/') ||
              req.url?.startsWith('/@') ||
              req.url?.startsWith('/api/') ||
              req.url?.startsWith('/public/') ||
              // JSON dosyaları için özel kontrol
              req.url?.match(/\.(json)$/) ||
              // Diğer static dosyalar
              req.url?.match(/\.(js|css|png|jpg|jpeg|gif|svg|ico|woff|woff2|ttf|eot|webp)$/)
            ) {
              return next();
            }
            // Diğer tüm istekleri index.html'e yönlendir (SPA routing)
            req.url = '/index.html';
            next();
          });
        };
      }
    }
  ],
  base: '/', // Base path (root'tan serve ediliyor)
  server: {
    port: 5173,
    host: true, // Tüm network interface'lerinde dinle (0.0.0.0)
    cors: true, // CORS'u etkinleştir
    // SPA routing için - tüm path'leri index.html'e yönlendir
    fs: {
      strict: false, // SPA routing için gerekli
    },
    // Chatwoot API proxy (opsiyonel - eğer CORS sorunu varsa)
    // proxy: {
    //   '/public/api': {
    //     target: 'https://call.betlabx.com',
    //     changeOrigin: true,
    //     secure: true
    //   },
    //   '/widget/api': {
    //     target: 'https://call.betlabx.com',
    //     changeOrigin: true,
    //     secure: true
    //   }
    // }
  },
  build: {
    outDir: 'dist',
    assetsDir: 'assets',
    // SPA routing için index.html'i her path için serve et
    rollupOptions: {
      input: {
        main: './index.html'
      }
    }
  }
});
